package code;
 /** 
 *  Represent the diropargs NFS2 data structure 
 **/ 
public class diropargs{

 /** 
 *  Data members 
 **/ 
  private final fhandle dir;
  private final String name;

 /** 
 *  Constructor 
 **/ 
  public
  diropargs(fhandle newDir, String newName){
    this.dir = newDir;
    this.name = newName;
  }

 /** 
 *  Return the directory handle 
 **/ 
  public fhandle
  getDir(){
    return(this.dir);
  }

 /** 
 *  Return the file name 
 **/ 
  public String
  getName(){
    return(this.name);
  }

 /** 
 *  Return true if "this" equals "obj" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    diropargs args = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof diropargs){
      args = (diropargs)obj;
      eq = (this.dir.equals(args.dir) && this.name.equals(args.name));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public final int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.dir.hashCode() ^ this.name.hashCode();
    return(code);
  }

  public String toString(){
    return "(dirfh=" + dir.toString() + " filename= " + name + ")";  
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("diropargs self test...");
    diropargs.test();
    System.err.println("...diropargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  test(){
    diropargs args1 = null;
    diropargs args2 = null;
    diropargs args3 = null;

    // Test 1
    args1 = new diropargs(fhandle.makeAllZeroHandle(), "abcd");
    assert(args1.getDir().equals(fhandle.makeAllZeroHandle()));
    assert(args1.getName().equals("abcd"));
    assert(args1.equals(args1));

    // Test 2
    args2 = new diropargs(fhandle.makeAllZeroHandle(), "asdf");
    assert(args2.getDir().equals(fhandle.makeAllZeroHandle()));
    assert(args2.getName().equals("asdf"));
    assert(args2.equals(args2));
    assert(!args1.equals(args2));
    assert(!args2.equals(args1));
    assert(args1.hashCode() != args2.hashCode());

    // Test 3
    args3 = new diropargs(fhandle.makeAllZeroHandle(), "abcd");
    assert(args3.getDir().equals(fhandle.makeAllZeroHandle()));
    assert(args3.getName().equals("abcd"));
    assert(args3.equals(args3));
    assert(args1.equals(args3));
    assert(args3.equals(args1));
    assert(!args2.equals(args3));
    assert(!args3.equals(args2));
    assert(args1.hashCode() == args3.hashCode());
    assert(args2.hashCode() != args3.hashCode());
  }
}
