package code;
 /** 
 *  Represent the diropres NFS2 data structure 
 **/ 

public class diropres implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final fhandle file;
  private final fattr attributes;

 /** 
 *  Constructor 
 **/ 
  public
  diropres(int newStatus, fhandle newFile, fattr newAttributes){
    this.status = newStatus;
    this.file = newFile;
    this.attributes = newAttributes;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the file 
 **/ 
  public fhandle
  getFile(){
    assert(this.status == stat.NFS_OK);
    return(this.file);
  }

 /** 
 *  Return the attributes 
 **/ 
  public fattr
  getAttributes(){
    assert(this.status == stat.NFS_OK);
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Return a String representation of this object 
 **/ 
  public String
  toString(){
    String str = null;
    
    if(this.status == stat.NFS_OK){
      str = ("(" + this.status +
             ", <fhandle>" +
             ", " + this.attributes +
             ")");
    }else{
      str = "(" + this.status + ", <error: " + this.status +">)";
    }
    return(str);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("diropres self test...");
    diropres.testSimple();
    System.err.println("...diropres self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    diropres dos1 = null;
    diropres dos2 = null;
    fhandle handle = null;
    fattr attr1 = null;
 
    dos1 = new diropres(stat.NFSERR_IO, null, null);
    assert(dos1.getStatus() == stat.NFSERR_IO);

    attr1 = new fattr(ftype.NFREG,
                      63,
                      36,
                      17,
                      58,
                      27,
                      18,
                      55,
                      22,
                      99,
                      108,
                      new timeval(34, 7),
                      new timeval(13, 84),
                      new timeval(21, 8));
    dos2 = new diropres(stat.NFS_OK, fhandle.makeAllZeroHandle(), attr1);
    assert(dos2.getStatus() == stat.NFS_OK);
    assert(dos2.getFile().equals(fhandle.makeAllZeroHandle()));
    assert(dos2.getAttributes().equals(attr1));
    //System.out.println("" + dos1); // Already tested
    //System.out.println("" + dos2); // Already tested
  }
}

 /** 
 *  $Log: diropres.java,v $ 
 *  Revision 1.3  2007/01/10 06:34:01  zjiandan 
 *  fixed "mount: localhost:practidir: can't read superblock" problem 
 *  and the Java P2 wrapper string problem. 
 *  
 *  Revision 1.2  2006/11/15 05:41:10  nayate 
 *  Added a toString() method 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
