package code;
 /** 
 *  Represent the entry NFS2 data structure 
 **/ 
import java.util.Arrays;

public class entry implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final long fileid;
  private final String name;
  private final long cookie;
  private final entry nextEntry;

 /** 
 *  Constructor 
 **/ 
  public
  entry(long newFileId, String newName, long newCookie, entry newNextEntry){
    this.fileid = newFileId;
    this.name = newName;
    this.cookie = newCookie;
    this.nextEntry = newNextEntry;
  }

 /** 
 *  Return the fileid 
 **/ 
  public long
  getFileId(){
    return(this.fileid);
  }

 /** 
 *  Return the name 
 **/ 
  public String
  getName(){
    return(this.name);
  }

 /** 
 *  Return the cookie 
 **/ 
  public long
  getCookie(){
    return(this.cookie);
  }

 /** 
 *  Return the next entry 
 **/ 
  public entry
  getNextEntry(){
    return(this.nextEntry);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("entry self test...");
    entry.testSimple();
    System.err.println("...entry self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    entry e1 = null;
    entry e2 = null;

    e1 = new entry(10, "asdf", 100, null);
    assert(e1.getFileId() == 10);
    assert(e1.getName().equals("asdf"));
    assert(e1.getCookie() == 100);
    assert(e1.getNextEntry() == null);

    e2 = new entry(11, "abcd", 101, e1);
    assert(e2.getFileId() == 11);
    assert(e2.getName().equals("abcd"));
    assert(e2.getCookie() == 101);
    assert(e2.getNextEntry() == e1);
  }
}

 /** 
 *  $Log: entry.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
