package code;
 /** 
 *  Store the NFS file attribute data structure 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

// Used for testing
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class fattr{

 /** 
 *  Constants 
 **/ 
  private static byte MAGIC_NUM = 4;

 /** 
 *  Data members 
 **/ 
  private long type;
  private long mode;
  private long nlink;
  private long uid;
  private long gid;
  private long size;
  private long blockSize;
  private long rdev;
  private long blocks;
  private long fsid;
  private long fileid;
  private timeval atime;
  private timeval mtime;
  private timeval ctime;

 /** 
 *  Constructor 
 **/ 
  public
  fattr(long newType,
        long newMode,
        long newNlink,
        long newUID,
        long newGID,
        long newSize,
        long newBlockSize,
        long newRdev,
        long newBlocks,
        long newFsid,
        long newFileid,
        timeval newAtime,
        timeval newMtime,
        timeval newCtime){
    this.type = newType;
    this.mode = newMode;
    this.nlink = newNlink;
    this.uid = newUID;
    this.gid = newGID;
    this.size = newSize;
    this.blockSize = newBlockSize;
    this.rdev = newRdev;
    this.blocks = newBlocks;
    this.fsid = newFsid;
    this.fileid = newFileid;
    this.atime = newAtime;
    this.mtime = newMtime;
    this.ctime = newCtime;
  }

 /** 
 *  Constructor 
 **/ 
  public
  fattr(sattr newAttr,
        long newType,
        long newMode,
        long newNlink,
        long newUID,
        long newGID,
        long newSize,
        long newBlockSize,
        long newRdev,
        long newBlocks,
        long newFsid,
        long newFileid,
        timeval newATime,
        timeval newMTime,
        timeval newCtime){
    this.type = newType;
    this.mode = newMode;
    this.nlink = newNlink;
    this.uid = newUID;
    this.gid = newGID;
    this.size = newSize;
    this.blockSize = newBlockSize;
    this.rdev = newRdev;
    this.blocks = newBlocks;
    this.fsid = newFsid;
    this.fileid = newFileid;
    this.atime = newATime;
    this.mtime = newMTime;
    this.ctime = newCtime;

    if((newAttr.getMode() <= Integer.MAX_VALUE) && (newAttr.getMode() >= 0)){
      this.mode = newAttr.getMode();
    }
    if((newAttr.getUID() <= Integer.MAX_VALUE) && (newAttr.getUID() >= 0)){
      this.uid = newAttr.getUID();
    }
    if((newAttr.getGID() <= Integer.MAX_VALUE) && (newAttr.getGID() >= 0)){
      this.gid = newAttr.getGID();
    }
    if((newAttr.getSize() <= Integer.MAX_VALUE) && (newAttr.getSize() >= 0)){
      this.size = newAttr.getSize();
    }
    if((newAttr.getATime().getSeconds() <= Integer.MAX_VALUE) &&
       (newAttr.getATime().getSeconds() >= 0)){
      this.atime = newAttr.getATime();
    }
    if((newAttr.getMTime().getSeconds() <= Integer.MAX_VALUE) &&
       (newAttr.getMTime().getSeconds() >= 0)){
      this.mtime = newAttr.getMTime();
    }
  }

 /** 
 *  Constructor 
 *  Read this object from the input stream 
 **/ 
  public
  fattr(InputStream is) throws IOException{
    DataInputStream dis = null;
    byte magicNum = (byte)0;

    dis = new DataInputStream(is);
    magicNum = dis.readByte();
    assert(magicNum == fattr.MAGIC_NUM);
    this.type = dis.readLong();
    this.mode = dis.readLong();
    this.nlink = dis.readLong();
    this.uid = dis.readLong();
    this.gid = dis.readLong();
    this.size = dis.readLong();
    this.blockSize = dis.readLong();
    this.rdev = dis.readLong();
    this.blocks = dis.readLong();
    this.fsid = dis.readLong();
    this.fileid = dis.readLong();
    this.atime = new timeval(dis);
    this.mtime = new timeval(dis);
    this.ctime = new timeval(dis);
  }

 /** 
 *  Write this object to the OutputStream 
 **/ 
  public void
  toOutputStream(OutputStream os) throws IOException{
    DataOutputStream dos = null;

    dos = new DataOutputStream(os);
    dos.writeByte(fattr.MAGIC_NUM);
    dos.writeLong(this.type);
    dos.writeLong(this.mode);
    dos.writeLong(this.nlink);
    dos.writeLong(this.uid);
    dos.writeLong(this.gid);
    dos.writeLong(this.size);
    dos.writeLong(this.blockSize);
    dos.writeLong(this.rdev);
    dos.writeLong(this.blocks);
    dos.writeLong(this.fsid);
    dos.writeLong(this.fileid);
    this.atime.toOutputStream(dos);
    this.mtime.toOutputStream(dos);
    this.ctime.toOutputStream(dos);
  }

 /** 
 *  Return the type 
 **/ 
  public long
  getType(){
    return(this.type);
  }

 /** 
 *  Return the mode 
 **/ 
  public long
  getMode(){
    return(this.mode);
  }

 /** 
 *  Return nlink 
 **/ 
  public long
  getNLink(){
    return(this.nlink);
  }

 /** 
 *  Return the uid 
 **/ 
  public long
  getUID(){
    return(this.uid);
  }

 /** 
 *  Return the gid 
 **/ 
  public long
  getGID(){
    return(this.gid);
  }

 /** 
 *  Return the size 
 **/ 
  public long
  getSize(){
    return(this.size);
  }

 /** 
 *  Return the block size 
 **/ 
  public long
  getBlockSize(){
    return(this.blockSize);
  }

 /** 
 *  Return the value of rdev 
 **/ 
  public long
  getRDev(){
    return(this.rdev);
  }

 /** 
 *  Return the number of used blocks 
 **/ 
  public long
  getBlocks(){
    return(this.blocks);
  }

 /** 
 *  Return the fsid 
 **/ 
  public long
  getFSID(){
    return(this.fsid);
  }

 /** 
 *  Return the fileid 
 **/ 
  public long
  getFileId(){
    return(this.fileid);
  }

 /** 
 *  Return the atime 
 **/ 
  public timeval
  getATime(){
    return(this.atime);
  }

 /** 
 *  Return the mtime 
 **/ 
  public timeval
  getMTime(){
    return(this.mtime);
  }

 /** 
 *  Return the ctime 
 **/ 
  public timeval
  getCTime(){
    return(this.ctime);
  }

 /** 
 *  Set the mode 
 **/ 
  public void
  setMode(long newMode){
    this.mode = newMode;
  }

 /** 
 *  Set the uid 
 **/ 
  public void
  setUID(long newUID){
    this.uid = newUID;
  }

 /** 
 *  Set the gid 
 **/ 
  public void
  setGID(long newGID){
    this.gid = newGID;
  }

 /** 
 *  Set the size 
 **/ 
  public void
  setSize(long newSize){
    this.size = newSize;
  }

 /** 
 *  Set the atime 
 **/ 
  public void
  setATime(timeval newATime){
    this.atime = newATime;
  }

 /** 
 *  Set the mtime 
 **/ 
  public void
  setMTime(timeval newMTime){
    this.mtime = newMTime;
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    fattr attr = null;

    // 2 Java-declared fields, 15 self-declared fields
    //System.out.println(this.getClass().getDeclaredFields().length);
    assert(fattr.class.getDeclaredFields().length == 17);
    if(obj instanceof fattr){
      attr = (fattr)obj;
      eq = ((this.type == attr.type) &&
            (this.mode == attr.mode) &&
            (this.nlink == attr.nlink) &&
            (this.uid == attr.uid) &&
            (this.gid == attr.gid) &&
            (this.size == attr.size) &&
            (this.blockSize == attr.blockSize) &&
            (this.rdev == attr.rdev) &&
            (this.blocks == attr.blocks) &&
            (this.fsid == attr.fsid) &&
            (this.fileid == attr.fileid) &&
            (this.atime.equals(attr.atime)) &&
            (this.mtime.equals(attr.mtime)) &&
            (this.ctime.equals(attr.ctime)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 15 self-declared fields
    assert(fattr.class.getDeclaredFields().length == 17);
    code = ((new Long(this.type)).hashCode() ^
            (new Long(this.mode)).hashCode() ^
            (new Long(this.nlink)).hashCode() ^
            (new Long(this.uid)).hashCode() ^
            (new Long(this.gid)).hashCode() ^
            (new Long(this.size)).hashCode() ^
            (new Long(this.rdev)).hashCode() ^
            (new Long(this.blocks)).hashCode() ^
            (new Long(this.fsid)).hashCode() ^
            (new Long(this.fileid)).hashCode() ^
            (this.atime.hashCode()) ^
            (this.mtime.hashCode()) ^
            (this.ctime.hashCode()));
    return(code);
  }

 /** 
 *  Return a String represntation for this object 
 **/ 
  public String
  toString(){
    String str = null;

    str = ("(type = " + this.type +
           ", mode = " + this.mode +
	   ", nlink = " + this.nlink +
	   ", size = " + this.size +
	   ", fsid = " + this.fsid +
	   ", fileid = " + this.fileid +
           ", atime = " + this.atime +
           ", mtime = " + this.mtime +
           ", ctime = " +  this.ctime +
           ")");
    return(str);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing fattr.java...");
    fattr.testSimple();
    fattr.testEqualsHashCode();
    fattr.testSerialize();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    fattr attr1 = null;
    fattr attr2 = null;
    sattr sat = null;

    // Test get methods
    attr1 = new fattr(ftype.NFREG,
                      36,
                      63,
                      71,
                      85,
                      32,
                      81,
                      55,
                      22,
                      99,
                      108,
                      new timeval(43, 7),
                      new timeval(31, 48),
                      new timeval(12, 8));
    assert(attr1.getType() == ftype.NFREG);
    assert(attr1.getMode() == 36);
    assert(attr1.getNLink() == 63);
    assert(attr1.getUID() == 71);
    assert(attr1.getGID() == 85);
    assert(attr1.getSize() == 32);
    assert(attr1.getBlockSize() == 81);
    assert(attr1.getRDev() == 55);
    assert(attr1.getBlocks() == 22);
    assert(attr1.getFSID() == 99);
    assert(attr1.getFileId() == 108);
    assert(attr1.getATime().equals(new timeval(43, 7)));
    assert(attr1.getMTime().equals(new timeval(31, 48)));
    assert(attr1.getCTime().equals(new timeval(12, 8)));
    //System.out.println("" + attr1); // Already tested

    // Test set methods
    attr1.setMode(48);
    assert(attr1.getMode() == 48);
    attr1.setUID(49);
    assert(attr1.getUID() == 49);
    attr1.setGID(92);
    assert(attr1.getGID() == 92);
    attr1.setSize(23);
    assert(attr1.getSize() == 23);
    attr1.setATime(new timeval(33, 78));
    assert(attr1.getATime().equals(new timeval(33, 78)));
    attr1.setMTime(new timeval(76, 21));
    assert(attr1.getMTime().equals(new timeval(76, 21)));

    // Test the second constructor
    sat = new sattr(-1, 71, 85, -1, new timeval(-1, -1), new timeval(31, 48));
    attr2 = new fattr(sat,
                      ftype.NFREG, // type
                      36, // mode
                      63, // nlink
                      0, // uid
                      0, // gid
                      32, // size
                      81, // blocksize
                      55, // rdev
                      22, // blocks
                      99, // fsid
                      108, // fileid
                      new timeval(43, 7),
                      new timeval(-1, -1),
                      new timeval(12, 8));
    assert(attr2.getType() == ftype.NFREG);
    assert(attr2.getMode() == 36);
    assert(attr2.getNLink() == 63);
    assert(attr2.getUID() == 71);
    assert(attr2.getGID() == 85);
    assert(attr2.getSize() == 32);
    assert(attr2.getBlockSize() == 81);
    assert(attr2.getRDev() == 55);
    assert(attr2.getBlocks() == 22);
    assert(attr2.getFSID() == 99);
    assert(attr2.getFileId() == 108);
    assert(attr2.getATime().equals(new timeval(43, 7)));
    assert(attr2.getMTime().equals(new timeval(31, 48)));
    assert(attr2.getCTime().equals(new timeval(12, 8)));
  }

 /** 
 *  Test the equals() method 
 **/ 
  private static void
  testEqualsHashCode(){
    fattr attr1 = null;
    fattr attr2 = null;
    fattr attr3 = null;

    // Test1: Self comparison
    attr1 = new fattr(ftype.NFREG,
                      36,
                      63,
                      71,
                      85,
                      72,
                      81,
                      55,
                      22,
                      99,
                      108,
                      new timeval(43, 7),
                      new timeval(31, 48),
                      new timeval(12, 8));
    assert(attr1.equals(attr1));

    // Test 2: Compare to another, equal object
    attr2 = new fattr(ftype.NFREG,
                      36,
                      63,
                      71,
                      85,
                      72,
                      81,
                      55,
                      22,
                      99,
                      108,
                      new timeval(43, 7),
                      new timeval(31, 48),
                      new timeval(12, 8));
    assert(attr2.equals(attr2));
    assert(attr1.equals(attr2));
    assert(attr2.equals(attr1));
    assert(attr1.hashCode() == attr2.hashCode());

    // Test 3: Compare to a (slightly) unequal object
    attr3 = new fattr(ftype.NFDIR,
                      36,
                      63,
                      71,
                      85,
                      72,
                      81,
                      55,
                      22,
                      99,
                      108,
                      new timeval(43, 7),
                      new timeval(31, 48),
                      new timeval(12, 8));
    assert(!attr1.equals(attr3));
    assert(!attr3.equals(attr1));
    assert(!attr2.equals(attr3));
    assert(!attr3.equals(attr2));
    assert(attr3.hashCode() != attr1.hashCode());
    assert(attr3.hashCode() != attr2.hashCode());
    assert(attr3.equals(attr3));
  }

 /** 
 *  Test serialization/deserialization 
 **/ 
  private static void
  testSerialize(){
    fattr fattr1 = null;
    fattr fattr2 = null;
    ByteArrayInputStream bais = null;
    ByteArrayOutputStream baos = null;
    byte[] b = null;

    try{
      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      fattr1 = new fattr(ftype.NFREG,
                         36,
                         63,
                         71,
                         85,
                         72,
                         81,
                         55,
                         22,
                         99,
                         108,
                         new timeval(43, 7),
                         new timeval(31, 48),
                         new timeval(12, 8));
      fattr1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      fattr2 = new fattr(bais);
      assert(fattr1.equals(fattr2));
      assert(fattr2.equals(fattr1));
      assert(fattr1 != fattr2);

      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      fattr1 = new fattr(ftype.NFDIR,
                         63,
                         36,
                         17,
                         58,
                         27,
                         18,
                         55,
                         22,
                         99,
                         108,
                         new timeval(34, 70),
                         new timeval(13, 84),
                         new timeval(21, 80));
      fattr1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      fattr2 = new fattr(bais);
      assert(fattr1.equals(fattr2));
      assert(fattr2.equals(fattr1));
      assert(fattr1 != fattr2);
    }catch(IOException e){
      assert false : ("" + e);
    }
  }
}
