package code;
 /** 
 *  Represent the linkargs NFS2 data structure 
 **/ 

class linkargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final fhandle from;
  private final diropargs to;

 /** 
 *  Constructor 
 **/ 
  public
  linkargs(fhandle newFrom, diropargs newTo){
    this.from = newFrom;
    this.to = newTo;
  }

 /** 
 *  Return the file handle 
 **/ 
  public fhandle
  getFrom(){
    return(this.from);
  }

 /** 
 *  Return the directory operations argument 
 **/ 
  public diropargs
  getTo(){
    return(this.to);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("linkargs self test...");
    linkargs.testSimple();
    System.err.println("...linkargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    linkargs args1 = null;
    diropargs to = null;
 
    to = new diropargs(fhandle.makeAllZeroHandle(), "abcd");
    args1 = new linkargs(fhandle.makeAllZeroHandle(), to);
    assert(args1.getFrom().equals(fhandle.makeAllZeroHandle()));
    assert(args1.getTo().equals(new diropargs(fhandle.makeAllZeroHandle(),
                                              "abcd")));
  }
}

 /** 
 *  $Log: linkargs.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
