package code;
 /** 
 *  Represent the readargs NFS2 data structure 
 **/ 
public class readargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final fhandle file;
  private final long offset;
  private final long count;
  private final long totalCount;

 /** 
 *  Constructor 
 **/ 
  public
  readargs(fhandle newFile, long newOffset, long newCount, long newTotalCount){
    this.file = newFile;
    this.offset = newOffset;
    this.count = newCount;
    this.totalCount = newTotalCount;
  }

  public String
  toString(){
    return "(fh=" + file.toString() + ", " + offset + ", " + count + ")";  
  }
 /** 
 *  Return the file handle 
 **/ 
  public fhandle
  getFile(){
    return(this.file);
  }

 /** 
 *  Return the offset 
 **/ 
  public long
  getOffset(){
    return(this.offset);
  }

 /** 
 *  Return the count 
 **/ 
  public long
  getCount(){
    return(this.count);
  }

 /** 
 *  Return the totalCount (note: unused attribute) 
 **/ 
  public long
  getTotalCount(){
    return(this.totalCount);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("readargs self test...");
    readargs.testSimple();
    System.err.println("...readargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    readargs args1 = null;
    readargs args2 = null;
 
    args1 = new readargs(fhandle.makeAllZeroHandle(), 10, 15, 20);
    assert(args1.getFile().equals(fhandle.makeAllZeroHandle()));
    assert(args1.getOffset() == 10);
    assert(args1.getCount() == 15);
    assert(args1.getTotalCount() == 20);

    args2 = new readargs(fhandle.makeAllZeroHandle(), 4, 5, 6);
    assert(args2.getFile().equals(fhandle.makeAllZeroHandle()));
    assert(args2.getOffset() == 4);
    assert(args2.getCount() == 5);
    assert(args2.getTotalCount() == 6);
  }
}

 /** 
 *  $Log: readargs.java,v $ 
 *  Revision 1.2  2007/02/23 20:54:29  zjiandan 
 *  Fixed mem leak problems in NFS2Interface and some other bugs. 
 *  Andrew benchmark passed, performance still needs to tune. 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
