package code;
 /** 
 *  Represent the readdirargs NFS2 data structure 
 **/ 
import java.util.Arrays;

public class readdirargs implements Immutable{

 /** 
 *  Constants 
 **/ 
  public static final int COOKIESIZE = 4;

 /** 
 *  Data members 
 **/ 
  private final fhandle dir;
  private final long cookie;
  private final long count;

 /** 
 *  Constructor 
 **/ 
  public
  readdirargs(fhandle newDir, long newCookie, long newCount){
    this.dir = newDir;
    this.cookie = newCookie;
    this.count = newCount;
  }

  public String
  toString(){
    return "dirfh=" + dir.toString() + ", cookie=" + cookie + ", count=" + count;
  }
 /** 
 *  Return the file handle 
 **/ 
  public fhandle
  getDir(){
    return(this.dir);
  }

 /** 
 *  Return the cookie 
 **/ 
  public long
  getCookie(){
    return(this.cookie);
  }

 /** 
 *  Return the count 
 **/ 
  public long
  getCount(){
    return(this.count);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("readdirargs self test...");
    readdirargs.testSimple();
    System.err.println("...readdirargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    readdirargs args = null;
 
    args = new readdirargs(fhandle.makeAllZeroHandle(), 100, 10);
    assert(args.getDir().equals(fhandle.makeAllZeroHandle()));
    assert(args.getCookie() == 100);
    assert(args.getCount() == 10);
  }
}

 /** 
 *  $Log: readdirargs.java,v $ 
 *  Revision 1.2  2007/02/23 20:54:29  zjiandan 
 *  Fixed mem leak problems in NFS2Interface and some other bugs. 
 *  Andrew benchmark passed, performance still needs to tune. 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
