package code;
 /** 
 *  Represent the readdirres NFS2 data structure 
 **/ 
import java.util.Arrays;

public class readdirres implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final entry entries;
  private final boolean eof;

 /** 
 *  Constructor 
 **/ 
  public
  readdirres(int newStatus, entry newEntries, boolean newEOF){
    this.status = newStatus;
    this.entries = newEntries;
    this.eof = newEOF;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the entries 
 **/ 
  public entry
  getEntries(){
    assert(this.status == stat.NFS_OK);
    return(this.entries);
  }

 /** 
 *  Return the eof flag 
 **/ 
  public boolean
  getEOF(){
    assert(this.status == stat.NFS_OK);
    return(this.eof);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("readdirres self test...");
    readdirres.testSimple();
    System.err.println("...readdirres self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    readdirres rdr1 = null;
    readdirres rdr2 = null;
    entry entries = null;
 
    rdr1 = new readdirres(stat.NFSERR_IO, null, false);
    assert(rdr1.getStatus() == stat.NFSERR_IO);

    entries = new entry(10, "asdf", 107, null);
    rdr2 = new readdirres(stat.NFS_OK, entries, true);
    assert(rdr2.getStatus() == stat.NFS_OK);
    assert(rdr2.getEntries() == entries);
    assert(rdr2.getEOF());
  }
}

 /** 
 *  $Log: readdirres.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
