package code;
 /** 
 *  Represent the readlinkres NFS2 data structure 
 **/ 

class readlinkres implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final String data;

 /** 
 *  Constructor 
 **/ 
  public
  readlinkres(int newStatus, String newData){
    this.status = newStatus;
    this.data = newData;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the attributes 
 **/ 
  public String
  getData(){
    assert(this.status == stat.NFS_OK);
    return(this.data);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("readlinkres self test...");
    readlinkres.testSimple();
    System.err.println("...readlinkres self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    readlinkres rlr1 = null;
    readlinkres rlr2 = null;
 
    rlr1 = new readlinkres(stat.NFSERR_IO, null);
    assert(rlr1.getStatus() == stat.NFSERR_IO);

    rlr2 = new readlinkres(stat.NFS_OK, "Some path");
    assert(rlr2.getStatus() == stat.NFS_OK);
    assert(rlr2.getData().equals("Some path"));
  }
}

 /** 
 *  $Log: readlinkres.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
