package code;
 /** 
 *  Represent the readres NFS2 data structure 
 **/ 
public class readres implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final fattr attributes;
  private final byte[] data;

 /** 
 *  Constructor 
 **/ 
  public
  readres(int newStatus, fattr newAttributes, byte[] newData){
    this.status = newStatus;
    this.attributes = newAttributes;
    this.data = newData;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the attributes 
 **/ 
  public fattr
  getAttributes(){
    assert(this.status == stat.NFS_OK);
    return(this.attributes);
  }

 /** 
 *  Return the data 
 **/ 
  public byte[]
  getData(){
    assert(this.status == stat.NFS_OK);
    return(this.data);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("readres self test...");
    readres.testSimple();
    System.err.println("...readres self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    readres rr1 = null;
    readres rr2 = null;
    fattr attr1 = null;
    byte[] data = null;
 
    rr1 = new readres(stat.NFSERR_IO, null, null);
    assert(rr1.getStatus() == stat.NFSERR_IO);

    attr1 = new fattr(ftype.NFREG,
                      63,
                      36,
                      17,
                      58,
                      27,
                      18,
                      55,
                      22,
                      99,
                      108,
                      new timeval(34, 7),
                      new timeval(13, 84),
                      new timeval(21, 8));
    data = new byte[100];
    data[0] = 10;
    rr2 = new readres(stat.NFS_OK, attr1, data);
    assert(rr2.getStatus() == stat.NFS_OK);
    assert(rr2.getAttributes().equals(attr1));
    data = rr2.getData();
    assert(data[0] == 10);
  }
}

 /** 
 *  $Log: readres.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
