package code;
 /** 
 *  Represent the renameargs NFS2 data structure 
 **/ 

class renameargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final diropargs from;
  private final diropargs to;

 /** 
 *  Constructor 
 **/ 
  public
  renameargs(diropargs newFrom, diropargs newTo){
    this.from = newFrom;
    this.to = newTo;
  }

  public String
  toString(){
    return "(from=" + from.toString() + ", to= " + to.toString();
  }

 /** 
 *  Return the source directory operations 
 **/ 
  public diropargs
  getFrom(){
    return(this.from);
  }

 /** 
 *  Return the destination directory operations 
 **/ 
  public diropargs
  getTo(){
    return(this.to);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("renameargs self test...");
    renameargs.testSimple();
    System.err.println("...renaeargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    renameargs args1 = null;
    diropargs from = null;
    diropargs to = null;
 
    from = new diropargs(fhandle.makeAllZeroHandle(), "abcd");
    to = new diropargs(fhandle.makeAllZeroHandle(), "wxyz");
    args1 = new renameargs(from, to);
    assert(args1.getFrom().equals(new diropargs(fhandle.makeAllZeroHandle(),
                                                "abcd")));
    assert(args1.getTo().equals(new diropargs(fhandle.makeAllZeroHandle(),
                                              "wxyz")));
  }
}

 /** 
 *  $Log: renameargs.java,v $ 
 *  Revision 1.2  2007/02/23 20:54:29  zjiandan 
 *  Fixed mem leak problems in NFS2Interface and some other bugs. 
 *  Andrew benchmark passed, performance still needs to tune. 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
