package code;
 /** 
 *  Represent the sattr NFS2 data structures 
 **/ 
class sattr implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final long mode;
  private final long uid;
  private final long gid;
  private final long size;
  private final timeval atime;
  private final timeval mtime;

 /** 
 *  Constructor 
 **/ 
  public
  sattr(long newMode,
        long newUID,
        long newGID,
        long newSize,
        timeval newATime,
        timeval newMTime){
    this.mode = newMode;
    this.uid = newUID;
    this.gid = newGID;
    this.size = newSize;
    this.atime = newATime;
    this.mtime = newMTime;
  }

 /** 
 *  Return the mode 
 **/ 
  public long
  getMode(){
    return(this.mode);
  }

 /** 
 *  Return the uid 
 **/ 
  public long
  getUID(){
    return(this.uid);
  }

 /** 
 *  Return the gid 
 **/ 
  public long
  getGID(){
    return(this.gid);
  }

 /** 
 *  Return the size 
 **/ 
  public long
  getSize(){
    return(this.size);
  }

 /** 
 *  Return the atime 
 **/ 
  public timeval
  getATime(){
    return(this.atime);
  }

 /** 
 *  Return the mtime 
 **/ 
  public timeval
  getMTime(){
    return(this.mtime);
  }

 /** 
 *  Return true if "obj" equals "this" (note: not implemented) 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    sattr attr = null;

    // 2 Java-declared fields, 6 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 8);
    if(obj instanceof sattr){
      attr = (sattr)obj;
      eq = ((this.mode == attr.mode) &&
            (this.uid == attr.uid) &&
            (this.gid == attr.gid) &&
            (this.size == attr.size) &&
            this.atime.equals(attr.atime) &&
            this.mtime.equals(attr.mtime));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 6 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 8);
    code = ((new Long(this.mode)).hashCode() ^
            (new Long(this.uid)).hashCode() ^
            (new Long(this.gid)).hashCode() ^
            (new Long(this.size)).hashCode() ^
            this.atime.hashCode() ^
            this.mtime.hashCode());
    return(code);
  }

 /** 
 *  Return a String representation of this object 
 **/ 
  public String
  toString(){
    String str = null;

    str = ("(" + this.mode +
           ", " + this.uid +
           ", " + this.gid + 
           ", " + this.size +
           ", " + this.atime.toString() +
           ", " + this.mtime.toString() +
           ")");
    return(str);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("sattr self test...");
    sattr.testSimple();
    sattr.testEquals();
    System.err.println("...sattr self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    sattr s1 = null;

    s1 = new sattr(100, 200, 300, 400, new timeval(5, 6), new timeval(7, 8));
    assert(s1.getMode() == 100);
    assert(s1.getUID() == 200);
    assert(s1.getGID() == 300);
    assert(s1.getSize() == 400);
    assert(s1.getATime().equals(new timeval(5, 6)));
    assert(s1.getMTime().equals(new timeval(7, 8))); 
    // System.out.println("" + s1); // NOTE: Tested already
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testEquals(){
    sattr s1 = null;
    sattr s2 = null;
    sattr s3 = null;

    s1 = new sattr(100, 200, 300, 400, new timeval(5, 6), new timeval(7, 8));
    assert(s1.equals(s1));

    s2 = new sattr(100, 200, 300, 400, new timeval(1, 8), new timeval(2, 2));
    assert(s2.equals(s2));
    assert(!s2.equals(s1));
    assert(!s1.equals(s2));
    assert(s1.hashCode() != s2.hashCode());

    s3 = new sattr(100, 200, 300, 400, new timeval(5, 6), new timeval(7, 8));
    assert(s3.equals(s3));
    assert(!s3.equals(s2));
    assert(!s2.equals(s3));
    assert(s1.equals(s3));
    assert(s3.equals(s1));
    assert(s1.hashCode() == s3.hashCode());
    assert(s2.hashCode() != s3.hashCode());
  }
}

 /** 
 *  $Log: sattr.java,v $ 
 *  Revision 1.2  2006/11/15 05:42:22  nayate 
 *  Added a toString() method 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 *  Revision 1.1  2006/06/12 20:07:20  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
