package code;
 /** 
 *  Represent the sattrargs NFS2 data structure 
 **/ 
public class sattrargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final fhandle file;
  private final sattr attributes;

 /** 
 *  Constructor 
 **/ 
  public
  sattrargs(fhandle newFile, sattr newAttributes){
    this.file = newFile;
    this.attributes = newAttributes;
  }

 /** 
 *  Return the file handle 
 **/ 
  public fhandle
  getFile(){
    return(this.file);
  }

 /** 
 *  Return the attributes 
 **/ 
  public sattr
  getAttributes(){
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

  public String 
    toString(){
    return "(file= " + file.toString() + ", sattr=" + attributes.toString();
  }
 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("sattrargs self test...");
    sattrargs.testSimple();
    System.err.println("...sattrargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    sattrargs args = null;

    args = new sattrargs(fhandle.makeAllZeroHandle(),
                         new sattr(1,
                                   2,
                                   3,
                                   4,
                                   new timeval(5, 6),
                                   new timeval(7, 8)));
    assert(args.getFile().equals(fhandle.makeAllZeroHandle()));
    assert(args.getAttributes().equals(new sattr(1,
                                                 2,
                                                 3,
                                                 4,
                                                 new timeval(5, 6),
                                                 new timeval(7, 8))));
  }
}

 /** 
 *  $Log: sattrargs.java,v $ 
 *  Revision 1.2  2007/02/23 20:54:29  zjiandan 
 *  Fixed mem leak problems in NFS2Interface and some other bugs. 
 *  Andrew benchmark passed, performance still needs to tune. 
 *  
 *  Revision 1.1  2006/07/15 02:54:22  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
