package code;
 /** 
 *  Represent the statfsres NFS2 data structure 
 **/ 
import java.util.Arrays;

public class statfsres implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final long tsize;
  private final long bsize;
  private final long blocks;
  private final long bfree;
  private final long bavail;

 /** 
 *  Constructor 
 **/ 
  public
  statfsres(int newStatus,
            long newTSize,
            long newBSize,
            long newBlocks,
            long newBFree,
            long newBAvail){
    this.status = newStatus;
    this.tsize = newTSize;
    this.bsize = newBSize;
    this.blocks = newBlocks;
    this.bfree = newBFree;
    this.bavail = newBAvail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the tsize value 
 **/ 
  public long
  getTSize(){
    assert(this.status == stat.NFS_OK);
    return(this.tsize);
  }

 /** 
 *  Return the bsize value 
 **/ 
  public long
  getBSize(){
    assert(this.status == stat.NFS_OK);
    return(this.bsize);
  }

 /** 
 *  Return the blocks value 
 **/ 
  public long
  getBlocks(){
    assert(this.status == stat.NFS_OK);
    return(this.blocks);
  }

 /** 
 *  Return the bfree value 
 **/ 
  public long
  getBFree(){
    assert(this.status == stat.NFS_OK);
    return(this.bfree);
  }

 /** 
 *  Return the bavail value 
 **/ 
  public long
  getBAvail(){
    assert(this.status == stat.NFS_OK);
    return(this.bavail);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  toString 
 **/ 
  public String toString(){
    return "statfsres = " + status + " ";
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("statfsres self test...");
    statfsres.testSimple();
    System.err.println("...statfsres self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    statfsres sfr1 = null;
    statfsres sfr2 = null;
 
    sfr1 = new statfsres(stat.NFSERR_IO, 0, 1, 2, 3, 4);
    assert(sfr1.getStatus() == stat.NFSERR_IO);

    sfr2 = new statfsres(stat.NFS_OK, 1, 2, 3, 4, 5);
    assert(sfr2.getStatus() == stat.NFS_OK);
    assert(sfr2.getTSize() == 1);
    assert(sfr2.getBSize() == 2);
    assert(sfr2.getBlocks() == 3);
    assert(sfr2.getBFree() == 4);
    assert(sfr2.getBAvail() == 5);
  }
}

 /** 
 *  $Log: statfsres.java,v $ 
 *  Revision 1.2  2007/01/10 06:34:01  zjiandan 
 *  fixed "mount: localhost:practidir: can't read superblock" problem 
 *  and the Java P2 wrapper string problem. 
 *  
 *  Revision 1.1  2006/07/15 02:54:22  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
