package code;
 /** 
 *  Represent the symlinkargs NFS2 data structure 
 **/ 

class symlinkargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final diropargs from;
  private final String to;
  private final sattr attributes;

 /** 
 *  Constructor 
 **/ 
  public
  symlinkargs(diropargs newFrom, String newTo, sattr newAttributes){
    this.from = newFrom;
    this.to = newTo;
    this.attributes = newAttributes;
  }

 /** 
 *  Return the directory operations 
 **/ 
  public diropargs
  getFrom(){
    return(this.from);
  }

 /** 
 *  Return the name 
 **/ 
  public String
  getTo(){
    return(this.to);
  }

 /** 
 *  Return the attributes 
 **/ 
  public sattr
  getAttributes(){
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("symlinkargs self test...");
    symlinkargs.testSimple();
    System.err.println("...symlinkargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    symlinkargs args = null;
    diropargs from = null;
    String to = null;
    sattr attr = null;
 
    from = new diropargs(fhandle.makeAllZeroHandle(), "abcd");
    to = "asdf";
    attr = new sattr(1, 3, 5, 7, new timeval(9, 11), new timeval(13, 15));
    args = new symlinkargs(from, to, attr);
    assert(args.getFrom().equals(from));
    assert(args.getTo().equals(to));
    assert(args.getAttributes().equals(attr));
  }
}

 /** 
 *  $Log: symlinkargs.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:22  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
