package code;
 /** 
 *  Store constants used as status values 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.text.DecimalFormat;

// Used for testing
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class timeval{

 /** 
 *  Constants 
 **/ 
  public static byte MAGIC_NUM = 3;

 /** 
 *  Data members 
 **/ 
  private final long seconds;
  private final long useconds;

 /** 
 *  Constructor 
 **/ 
  public
  timeval(long newSeconds, long newUSeconds){
    this.seconds = newSeconds;
    this.useconds = newUSeconds;
  }

 /** 
 *  Constructor 
 **/ 
  public
  timeval(long timeMS){
    this.seconds = (long)(timeMS / 1000L);
    this.useconds = (long)((timeMS % 1000) * 1000L);
  }

 /** 
 *  Constructor 
 **/ 
  public
  timeval(InputStream is) throws IOException{
    DataInputStream dis = null;
    byte magicNum = 0;

    dis = new DataInputStream(is);
    magicNum = dis.readByte();
    assert(magicNum == timeval.MAGIC_NUM);
    this.seconds = dis.readLong();
    this.useconds = dis.readLong();
  }

 /** 
 *  Write out this object to the OutputStream 
 **/ 
  public void
  toOutputStream(OutputStream os) throws IOException{
    DataOutputStream dos = null;

    dos = new DataOutputStream(os);
    dos.writeByte(timeval.MAGIC_NUM);
    dos.writeLong(this.seconds);
    dos.writeLong(this.useconds);
    dos.flush();
  }

 /** 
 *  Return the seconds field 
 **/ 
  public final long
  getSeconds(){
    return(this.seconds);
  }

 /** 
 *  Return the useconds field 
 **/ 
  public final long
  getUSeconds(){
    return(this.useconds);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    timeval val = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof timeval){
      val = (timeval)obj;
      eq = ((this.seconds == val.seconds) && (this.useconds == val.useconds));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public final int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = ((new Long(this.seconds)).hashCode() ^
            (new Long(this.useconds)).hashCode());
    return(code);
  }

 /** 
 *  Return a String representation for this object 
 **/ 
  public String
  toString(){
    String str = null;
    DecimalFormat df = null;

    df = new DecimalFormat(".0000");
    str = this.seconds + df.format(((double)this.useconds) / 1000) + "s";
    return(str);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing timeval.java...");
    timeval.testSimple();
    timeval.testSerialize();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    timeval time1 = null;
    timeval time2 = null;
    timeval time3 = null;
    timeval time4 = null;

    // Test 1: Random
    time1 = new timeval(23, 12);
    assert(time1.getSeconds() == 23);
    assert(time1.getUSeconds() == 12);
    assert(time1.equals(time1));
    //System.out.println("" + time1); // NOTE: Tested

    // Test 2: Swapped
    time2 = new timeval(12, 23);
    assert(time2.getSeconds() == 12);
    assert(time2.getUSeconds() == 23);
    assert(time2.equals(time2));
    assert(!time1.equals(time2));
    assert(!time2.equals(time1));

    // Test 3: Equal
    time3 = new timeval(12, 23);
    assert(!time3.equals(time1));
    assert(!time1.equals(time3));
    assert(time3.equals(time2));
    assert(time2.equals(time3));
    assert(time3.equals(time3));

    // Test 4: Other constructor
    time4 = new timeval(7892345699L);
    assert(time4.getSeconds() == 7892345L);
    assert(time4.getUSeconds() == 699000L);
  }

 /** 
 *  Test serialization/deserialization 
 **/ 
  private static void
  testSerialize(){
    timeval nfstime1 = null;
    timeval nfstime2 = null;
    ByteArrayInputStream bais = null;
    ByteArrayOutputStream baos = null;
    byte[] b = null;

    try{
      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      nfstime1 = new timeval(23, 12);
      nfstime1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      nfstime2 = new timeval(bais);
      assert(nfstime1.equals(nfstime2));
      assert(nfstime2.equals(nfstime1));
      assert(nfstime1 != nfstime2);

      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      nfstime1 = new timeval(1978, 1980);
      nfstime1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      nfstime2 = new timeval(bais);
      assert(nfstime1.equals(nfstime2));
      assert(nfstime2.equals(nfstime1));
      assert(nfstime1 != nfstime2);
    }catch(IOException e){
      assert false : ("" + e);
    }
  }
}
