package code;
 /** 
 *  Represent the writeargs NFS2 data structure 
 **/ 
public class writeargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final fhandle file;
  private final long beginOffset;
  private final long offset;
  private final long totalCount;
  private final byte[] data;

 /** 
 *  Constructor 
 **/ 
  public
  writeargs(fhandle newFile,
            long newBeginOffset,
            long newOffset,
            long newTotalCount,
            byte[] newData){
    this.file = newFile;
    this.beginOffset = newBeginOffset;
    this.offset = newOffset;
    this.totalCount = newTotalCount;
    this.data = newData;
  }

 /** 
 *  Return the file handle 
 **/ 
  public fhandle
  getFile(){
    return(this.file);
  }

 /** 
 *  Return the beginning offset 
 **/ 
  public long
  getBeginOffset(){
    return(this.beginOffset);
  }

 /** 
 *  Return the beginning offset 
 **/ 
  public long
  getOffset(){
    return(this.offset);
  }

 /** 
 *  Return the totalCount 
 **/ 
  public long
  getTotalCount(){
    return(this.totalCount);
  }

 /** 
 *  Return the data 
 **/ 
  public byte[]
  getData(){
    return(this.data);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("writeargs self test...");
    writeargs.testSimple();
    System.err.println("...writeargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    writeargs args1 = null;
    writeargs args2 = null;
    byte[] data = null;

    data = new byte[100];
    data[0] = 15;
    args1 = new writeargs(fhandle.makeAllZeroHandle(), 2, 3, 5, data);
    assert(args1.getFile().equals(fhandle.makeAllZeroHandle()));
    assert(args1.getBeginOffset() == 2);
    assert(args1.getOffset() == 3);
    assert(args1.getTotalCount() == 5);
    data = args1.getData();
    assert(data[0] == 15);
    assert(data.length == 100);

    data = new byte[10];
    data[1] = 7;
    args2 = new writeargs(fhandle.makeAllZeroHandle(), 19, 23, 29, data);
    assert(args2.getFile().equals(fhandle.makeAllZeroHandle()));
    assert(args2.getBeginOffset() == 19);
    assert(args2.getOffset() == 23);
    assert(args2.getTotalCount() == 29);
    data = args2.getData();
    assert(data[1] == 7);
    assert(data.length == 10);
  }
}

 /** 
 *  $Log: writeargs.java,v $ 
 *  Revision 1.1  2006/07/15 02:54:22  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
