package code;
 /** 
 **/ 
public class NetAddr
{
    int _port;
    String _dns;

    public NetAddr(String dns, int port)
    {
	_port = port;
	_dns = dns;
    }

     /* overrides equals in class object */
    public boolean equals(Object addr){
        if(_port == ((NetAddr)addr).getPort() &&
	   _dns.equalsIgnoreCase(((NetAddr)addr).getDNS())){
            return true;
	}
	return false;
    }
    
    /* overrides hashCode in class object */
    public int hashCode(){
        Integer p = new Integer(_port);
        return (p.hashCode()^_dns.hashCode());
    }
  
    /* override toString in class object */
    public String toString(){
        return (_dns + ":" + _port);
    }
    
    public int getPort(){
        return _port;
    }

    public String getDNS(){
        return _dns;
    }
    
    public static void main(String[] argv){
	int port = (new Integer(argv[1])).intValue();
	NetAddr nAddr = new NetAddr(argv[0], port);
	NetAddr nAddr3 = new NetAddr(argv[0], port);
	NetAddr nAddr2 = new NetAddr(argv[0]+".cn", port*2);
	System.out.println(nAddr.hashCode());
	System.out.println(nAddr2.hashCode());
	System.out.println(nAddr3.hashCode());
	System.out.println(nAddr.toString());
	System.out.println(nAddr2.toString());
	System.out.println(nAddr.equals(nAddr));
	System.out.println(nAddr.equals(nAddr2));
	System.out.println(nAddr.equals(nAddr3));
    }
}

//---------------------------------------------------------------------------
/* $Log: NetAddr.java,v $
/* Revision 1.5  2004/04/26 22:56:34  nayate
/* Made getPort() and getDNS() public
/*
/* Revision 1.4  2004/04/16 22:53:51  lgao
/* Implement the hashCode function with XOR of two hash values.
/*
/* Revision 1.3  2004/04/16 22:13:14  lgao
/* Allows NetAddr to be used as hashtable keys.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
