package code;
 /** 
 *  Thread that listens for socket connections to receive updates 
 **/ 
import java.net.Socket;
import java.net.ServerSocket;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NiceReceiver extends Thread{
  private Core core;
  private Controller controller;
  private ServerSocket ss;
  private boolean shutdown;
  private static boolean dbg = false;
 /** 
 *  Constructor 
 **/ 
  public
  NiceReceiver(Core core_, Controller controller_){
    this.core = core_;
    this.controller = controller_;
    this.ss = null;
    this.shutdown = false;
  }
 

  public void shutdown(){
    shutdown = true;
    if (ss != null){
      try{
	ss.close();// this call will make any thread currently blocked in accept()
	
	// throw a SocketException
      }catch(IOException ioe){
	if(dbg){
	  Env.warn(" NiceReceiver shutting down ignore Exception: " 
			   +ioe.toString());
	}
      }
      ss = null;
    }
  }
 /** 
 *  Main thread method 
 **/ 
  public void
  run(){
    Socket connection = null;
    
    TaggedInputStream ois = null;
    NiceRecvWorker t = null;

    try{
      try{
        ss = new ServerSocket(Config.getPortNice(core.getMyNodeId()));
      }catch(IOException f){
	
        Env.warn("NiceReceiver cannot open server socket" + f);
        assert(false);
        return;
      }
      
      while(!shutdown){
        try{
          connection = ss.accept();  // Should not get a heartbeat socket
          connection.setTcpNoDelay(true);
          ois = new TaggedInputStream(connection.getInputStream());
          t = new NiceRecvWorker(ois,
                                 this.core,
                                 this.controller,
                                 connection);
          t.start();
        }
        catch(IOException e){
	  if(dbg){
	    Env.warn("NiceReceiver thread exception" + e 
		     + " dropping this request and continuing");
	  }
        }
      }
    }
    finally{
      if(ss != null){
        try{
          ss.close();
        }
        catch(IOException dfs){
        }
        ss = null;
      }
      if(t != null){
        t.interrupt();
        t = null;
      }
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: NiceReceiver.java,v $
/* Revision 1.6  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.5  2006/09/12 22:18:05  dahlin
/* Working to get the unit tests to all run. Up to RandomAccessState now go through. Note that to encourage people to run RASUnit, I have changed the parameters to --quick-- versions that are less extensive tests.
/*
/* Revision 1.4  2006/06/02 22:40:02  nalini
/* merged support for adding and removing ss for outgoing body streams
/*
/* Revision 1.3.2.1  2006/06/02 22:18:13  nalini
/* Supports addition and removeal of SS from Outgoing Body Streams
/*
/* Revision 1.3  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.2  2005/03/13 09:48:12  nayate
/* Added code to work with TCP-LP
/*
/* Revision 1.1  2005/02/28 20:25:59  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/* */
//---------------------------------------------------------------------------
