package code;
 /** 
 *  Represents a connection that sends data and keeps trying to reconnect 
 *  if it fails. 
 **/ 
import java.net.Socket;
import java.io.IOException;
import java.io.*;

public class NiceReconnectConnection implements SocketMagicConstant{

  private final long initialBackoffMS = 100;
  private final long maxBackoffMS = 100000;
  private long currentBackoffMS;
  private TaggedOutputStream s;
  private NetAddr netAddr;

  private boolean constrainedRouter = true;
  private NodeId myNodeId;
 /** 
 *  Constructor 
 **/ 
  public
  NiceReconnectConnection(NetAddr na, NodeId myNodeId_){
    this.netAddr = na;
    this.s = null;
    this.currentBackoffMS = initialBackoffMS;
    this.myNodeId = myNodeId_;
  }

  private static boolean warned = false;
 /** 
 *  Constructor 
 **/ 
  public synchronized void
  send(Object o) throws UnableToConnectException{
    Socket skt = null;
    ConstrainedOutputStream cos = null;

    while(true){  // Keep going until write succeeds or max timeout
      if(s == null){
        try{
          skt = new NiceSocket(netAddr.getDNS(), netAddr.getPort());
          skt.setTcpNoDelay(true);

          // Set constrainedRouter to true to enable bandwidth
          // limiter and delay router
          if(constrainedRouter){
            cos = new ConstrainedOutputStream(skt.getOutputStream(),
                                              Config.getBandwidth(this.myNodeId));
            s = new TaggedOutputStream(cos);
          }else{
            s = new TaggedOutputStream(skt.getOutputStream());
            cos = null;
          }

          // Any time we open a connection
          // the first thing we send is
          // the magic number and our nodeId so that the
          // receiving thread knows
          // who is talking.
          s.writeObject(new Long(PREFETCH_SOCKET_MAGIC));
          if(!warned){
            Env.warn("Don't use the same magic # for different "
                     + "types of connection (Replace this with "
                     + "RECONNECTION_CONNECTION_MAGIC or something) "
                     + "(and fix the receivers)");
            warned = true;
          }
          s.writeObject(this.myNodeId);
          this.currentBackoffMS = initialBackoffMS;
        }catch(IOException e){
          if(currentBackoffMS > maxBackoffMS){
            throw new UnableToConnectException();
          }
          try{
            Thread.sleep(currentBackoffMS);
            currentBackoffMS *= 2;
          }catch(InterruptedException e2){
            System.err.println("ReconnectConnection: " +
                               "InterruptedException thrown");
            assert(false);
          }
          s = null; // around we go again
          continue;
        }
      }
      try{
        s.writeObject(o);
        return;
      }catch(IOException f){
        // write failed -- must be a bad socket
        try{
          s.close();
          s = null;
          System.err.println("Exception " + f + " thrown");
        }
        catch(IOException g){
          // Ignore error on close
        }
      }
    } // While true
  }
}

//---------------------------------------------------------------------------
/* $Log: NiceReconnectConnection.java,v $
/* Revision 1.3  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.2  2005/03/13 09:48:12  nayate
/* Added code to work with TCP-LP
/*
/* Revision 1.1  2005/02/28 20:25:59  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/* */
//---------------------------------------------------------------------------
