//---------------------------------------------------------------------------
// NiceServerSocket: Implement a ServerSocket for a NiceSocket
//---------------------------------------------------------------------------
#include <jni.h>
#include "NiceServerSocket.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>

// Use a 8MB send buffer to cover large bw * delay
#define SEND_BUF_SIZE 8388608

//---------------------------------------------------------------------------
// Function prototyes
//---------------------------------------------------------------------------
void setSendBufferSize(int serverSockFD, int sendBufSize);



//---------------------------------------------------------------------------
// Make a server socket
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_NiceServerSocket_c_1makeServerSocket(JNIEnv *env,
								 jobject obj,
								 jint portNum)
{
#ifdef __CYGWIN__
  return -1;
#else
  jint sockFD = 0;
  jint retVal = 0;
  int optval = 1;
  char hname[128];
  struct hostent *hp = NULL;
  struct sockaddr_in serv_addr;

  // Open TCP socket
  if((sockFD = socket(AF_INET, SOCK_STREAM, 0)) < 0){
    printf("could not open socket");
    return(sockFD);
  }

  printf("Socket listening on port: %d\n", portNum);
  fflush(stdout);

  optval = 1;
  setsockopt(sockFD, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval));

  // Bind local address
  bzero((char *)&serv_addr, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(portNum);

  //gethostname(hname, 128);
  strcpy(hname, "localhost");
  if((hp = gethostbyname(hname)) == NULL){
    perror("tcp/sender gethostbyname");
    return(-1);
  }
  bcopy(hp->h_addr, &serv_addr.sin_addr.s_addr, hp->h_length);
  setSendBufferSize(sockFD, SEND_BUF_SIZE);

  if((retVal = bind(sockFD,
		    (struct sockaddr *)&serv_addr,
		    sizeof(serv_addr))) < 0){
    perror("server: can't bind local address");
    return(retVal);
  }

  listen(sockFD, 5);
  return(sockFD);
#endif
}

//---------------------------------------------------------------------------
// Accept a connection
//---------------------------------------------------------------------------
JNIEXPORT jint JNICALL Java_NiceServerSocket_c_1accept(JNIEnv *env,
						       jobject obj,
						       jint serverSockFD,
						       jbyteArray bArr)
{
#ifdef __CYGWIN__
  return -1;
#else
  jint sockFD = 0;
  int cli_len = 0;
  int make_it_one = 1;
  jbyte *addressBytes = NULL;
  struct sockaddr_in cli_addr;
  uint32_t addressLong = 0;

  // For debugging:
  int bufsize = 0;
  int size = sizeof(bufsize);

  cli_len = sizeof(cli_addr);
  sockFD = accept(serverSockFD,
		  (struct sockaddr *)(&cli_addr),
		  (socklen_t *)(&cli_len));
  if(sockFD < 0){
    perror("accept error");
  }else{
    // Hope that the array sent in is at least 4 bytes long!
    addressLong = ntohl(cli_addr.sin_addr.s_addr);
    addressBytes = (*env)->GetByteArrayElements(env, bArr, 0);
    addressBytes[0] = (addressLong >> 24);
    addressBytes[1] = (addressLong >> 16) & 0xFF;
    addressBytes[2] = (addressLong >> 8) & 0xFF;
    addressBytes[3] = addressLong & 0xFF;
    (*env)->ReleaseByteArrayElements(env, bArr, addressBytes, 0);
    setsockopt(sockFD, SOL_TCP, 15, &make_it_one, sizeof(int));

    // For debugging purposes
    getsockopt(sockFD, SOL_SOCKET, SO_SNDBUF, &bufsize, (socklen_t*)&size);
    printf("Send buffer size: %d, field size = %d\n", bufsize, size);
    fflush(stdout);
    // END
  }

  return(sockFD);
#endif
}

//---------------------------------------------------------------------------
// Grow the send buffer size
//---------------------------------------------------------------------------
void setSendBufferSize(int serverSockFD, int sendBufSize)
{
#ifdef __CYGWIN__
  return;
#else
  int size = 0;

  // Set the sending buffer size
  setsockopt(serverSockFD, SOL_SOCKET, SO_SNDBUF, &sendBufSize, sizeof(int));
  // See if this worked
  size = sizeof(sendBufSize);
  getsockopt(serverSockFD, SOL_SOCKET, SO_SNDBUF, &sendBufSize, &size);
  printf("sendBufSize = %d, size = %d\n", sendBufSize, size);
  fflush(stdout);
#endif
}
