package code;
 /** 
 *  Implementation of a TCP Nice ServerSocket object 
 **/ 
import java.net.Socket;
import java.net.ServerSocket;
import java.net.SocketImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.io.IOException;

public class NiceServerSocket extends ServerSocket{

 /** 
 *  JNI stuff 
 **/ 
  static{
    System.loadLibrary("niceservsock");
  }

  public native int c_makeServerSocket(int portNum);
  public native int c_accept(int serverSockFD, byte[] address);

 /** 
 *  Constructor 
 **/ 
  public
  NiceServerSocket(int portNum) throws IOException{
    if(NiceSocketImpl.cSupportsNice){
      this.serverSockFD = c_makeServerSocket(portNum);
    }
    else{
      this.stubSocket = new ServerSocket(portNum);
    }
  }

 /** 
 *  Listen for a connection and accept it 
 **/ 
  public Socket
  accept() throws IOException{

    if(NiceSocketImpl.cSupportsNice){
      int sockFD = 0;
      byte[] addr = null;
      NiceSocket socket = null;
      InetAddress inetAddress = null;
      NiceSocketImpl socketImpl = null;
      
      addr = new byte[4];
      sockFD = c_accept(this.serverSockFD, addr);
      inetAddress = InetAddress.getByAddress(addr);
      
      //System.out.println("" + inetAddress);
      socketImpl = new NiceSocketImpl(sockFD, inetAddress);
      
      socket = new NiceSocket(socketImpl);
      return(socket);
    }
    else{
      assert(this.stubSocket != null);
      return this.stubSocket.accept();
    }
  }

 /** 
 *  Used for testing. See NiceServerSocketUnit for more tests. 
 **/ 
  public static void
  main(String[] argv){
    Socket s = null;
    ServerSocket ss = null;

    try{
      ss = new ServerSocket(4500);
      s = ss.accept();
    }catch(IOException e){
      System.err.println("" + e);
    }
  }

 /** 
 *  Protected data 
 **/ 
  protected int serverSockFD = -1;

  //
  // If native implementation doesn't support low priority
  // channels, then just use normal priority sockets.
  //
  private ServerSocket stubSocket = null;
}
