package code;
import junit.textui.TestRunner;
import code.utils.junit.*;
import java.net.Socket;
import java.net.ServerSocket;
import java.net.SocketException;
import java.io.IOException;
import java.net.InetAddress;
import java.io.InputStream;
import java.io.OutputStream;

public class NiceServerSocketUnit extends MultiThreadedTestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  private boolean dbg = false;

  protected ServerSocket ss = null;
  protected int TESTSS_PORT = 5532;
  private int max = 23000; // bytes to send

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public NiceServerSocketUnit(String s){
    super(s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    if(dbg){
      Env.inform("NiceServerSocketUnit fixture starts");
    }
    ss = new ServerSocket(TESTSS_PORT);
    if(dbg){
      Env.inform("NiceServerSocketUnit fixture server socket created");
    }
  }

  protected void tearDown() throws Exception{
    ss.close();
    ss = null;
    super.tearDown();
  }


  /* 
   * TBD: Insert functions called testX for some X
   * TBD: Create instance of class to be tested and
   *      pass to worker threads
   */
  public void testNiceSockets(){
    TestCaseRunnable tcr[] = new TestCaseRunnable[2];

    tcr[0] = new TestWorkerServer(ss, max);
    tcr[1] = new TestWorkerClient(TESTSS_PORT, max);

    /*
     * Runs all of the worker threads and waits
     * for them to finish.
     */
    runTestCaseRunnables(tcr);
    
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containin every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static junit.framework.Test suite(){
    junit.framework.TestSuite suite 
      = new junit.framework.TestSuite(NiceServerSocketUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "NiceServerSocketUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }


/*
 * Define worker threads within main test class
 */

class TestWorkerServer extends TestCaseRunnable
{
  private ServerSocket ss;
  private int max;

  TestWorkerServer(ServerSocket ss, int nbytes){
    if(dbg){
      Env.inform("NiceServerSocketUnit server thread created");
    }
    this.ss = ss;
    max = nbytes;
  }

  public void runTestCase() throws IOException{
    int ii;
    byte b[] = new byte[1];
    b[0] = 42;
    Socket s = ss.accept();
    if(dbg){
      Env.inform("NiceServerSocketUnit server thread done accept");
    }
    InputStream is = s.getInputStream();
    OutputStream os = s.getOutputStream();
    if(dbg){
      Env.inform("NiceServerSocketUnit server has is and os");
    }
    for(ii = 0; ii < max; ii++){
      if(Thread.currentThread().isInterrupted()){
        return;
      }
      os.write(b);
    }
    if(dbg){
      Env.inform("NiceServerSocketUnit server done writing");
    }
    for(ii = 0; ii < max; ii++){
      if(Thread.currentThread().isInterrupted()){
        return;
      }
      is.read(b);
    }
    if(dbg){
      Env.inform("NiceServerSocketUnit server done reading");
    }
    is.close();
    os.close();
    s.close();
    return;
  }

}


class TestWorkerClient extends TestCaseRunnable
{
  private Socket s;
  private int max;
  private InetAddress localhost;
  private int port;

  TestWorkerClient(int port, int nbytes){
    max = nbytes;
    this.port = port;
  }

  public void runTestCase() throws IOException{
    int ii;
    byte b[] = new byte[1];
    b[0] = 42;
    if(dbg){
      Env.inform("NiceServerSocketUnit client thread created");
    }
    localhost = InetAddress.getLocalHost();
    if(dbg){
      Env.inform("NiceServerSocketUnit client localhost is " + localhost.toString());
    }
    s = new Socket(localhost, port);
    if(dbg){
      Env.inform("NiceServerSocketUnit client socket connected");
    }

    InputStream is = s.getInputStream();
    OutputStream os = s.getOutputStream();
    for(ii = 0; ii < max; ii++){ /* update loop condition */
      if(Thread.currentThread().isInterrupted()){
        return;
      }
      is.read(b);
    }
    if(dbg){
      Env.inform("NiceServerSocketUnit client done reading");
    }
    for(ii = 0; ii < max; ii++){
      if(Thread.currentThread().isInterrupted()){
        return;
      }
      os.write(b);
    }
    if(dbg){
      Env.inform("NiceServerSocketUnit client done writing");
    }
    is.close();
    os.close();
    s.close();
    return;
  }
}



}
