package code;
 /** 
 *  Implementation of a TCP Nice Socket object 
 **/ 
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketException;
import java.net.SocketOptions;
import java.io.IOException;

public class NiceSocket extends BGSocket{

 /** 
 *  Constructor 
 **/ 
  public
  NiceSocket(String serverName, int portNum) throws IOException{
    this(new NiceSocketImpl(), serverName, portNum);
  }

 /** 
 *  Constructor 
 **/ 
  protected
  NiceSocket(NiceSocketImpl socketImpl,
             String serverName,
             int portNum) throws IOException{
    super(socketImpl);
    this.niceSocketImpl = socketImpl;
    this.niceSocketImpl.create(true);
    this.niceSocketImpl.connect(serverName, portNum);
  }

 /** 
 *  Constructor 
 **/ 
  public
  NiceSocket(NiceSocketImpl socketImpl) throws IOException{
    super(socketImpl);
  }

 /** 
 *  Return true if the socket is connected 
 **/ 
  public boolean
  isConnected(){
    return(true);
  }

 /** 
 *  Turn off Nagle's algorithm (don't buffer any data ready to be sent) 
 **/ 
  public void
  setTcpNoDelay(boolean on) throws SocketException{
    this.niceSocketImpl.setOption(SocketOptions.TCP_NODELAY, new Boolean(on));
  }


 /** 
 *  Protected data 
 **/ 
  protected NiceSocketImpl niceSocketImpl;
}
