package code;
 /** 
 *  Implementation of a TCP Nice socket input stream. 
 *  
 *  Note: For windows compatibility the NiceSocketImpl 
 *  and NiceServerSocket will return plain-vanilla 
 *  sockets and this code will never be called.  
 **/ 
import java.io.InputStream;
import java.io.IOException;

public class NiceSocketInputStream extends InputStream{
 /** 
 *  JNI stuff 
 **/ 
//  static{
//    System.loadLibrary("libnicesockis");
//  }

  public native int c_recv(int sockFD, byte[] b, int off, int len);
  public native int c_close(int sockFD);

 /** 
 *  Constructor 
 **/ 
  public
  NiceSocketInputStream(int sockFD){
    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }

    this.sockFD = sockFD;

  }

 /** 
 *  Returns the number of bytes that can be read (or skipped over) from 
 *  this input stream without blocking by the next caller of a method for 
 *  this input stream. 
 **/ 
  public int
  available(){
    assert(false);
    return(0);
  }

 /** 
 *  Closes this input stream and releases any system resources associated 
 *  with the stream. 
 **/ 
  public void
  close() throws IOException{
    int retVal = 0;

    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }

    retVal = c_close(this.sockFD);
    if(retVal < 0){
      throw(new IOException("Error closing socket"));
    }
  }

 /** 
 *  Marks the current position in this input stream. 
 **/ 
  public void
  mark(int readlimit){
    assert(false);
  }

 /** 
 *  Tests if this input stream supports the mark and reset methods. 
 **/ 
  public boolean
  markSupported(){
    return(false);
  }

 /** 
 *  Reads the next byte of data from the input stream. 
 **/ 
  public int
  read(){
    assert(false);
    return(0);
  }

 /** 
 *  Reads some number of bytes from the input stream and stores them into 
 *  the buffer array b. 
 **/ 
  public int
  read(byte[] b) throws IOException{
    int retVal = 0;

    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }


    retVal = c_recv(this.sockFD, b, 0, b.length);
    if(retVal < 0){
      throw(new IOException("Error writing to socket"));
    }
    return(retVal);
  }

 /** 
 *  Reads up to len bytes of data from the input stream into an array 
 *  of bytes. 
 **/ 
  public int
  read(byte[] b, int off, int len) throws IOException{
    int retVal = 0;

    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }


    retVal = c_recv(this.sockFD, b, off, len);
    if(retVal < 0){
      throw(new IOException("Error writing to socket"));
    }
    return(retVal);
  }

 /** 
 *  Repositions this stream to the position at the time the 
 *  mark method was last called on this input stream. 
 **/ 
  public void
  reset(){
    assert(false);
  }

 /** 
 *  Skips over and discards n bytes of data from this input stream. 
 **/ 
  public long
  skip(long n){
    assert(false);
    return(0);
  }

 /** 
 *  Protected data 
 **/ 
  protected int sockFD;
}
