package code;
 /** 
 *  Implementation of a TCP Nice socket input stream 
 **/ 
import java.io.IOException;
import java.io.OutputStream;

public class NiceSocketOutputStream extends OutputStream{

 /** 
 *  JNI stuff 
 **/ 
  static{
    System.loadLibrary("nicesockos");
  }

  public native int c_send(int sockFD, byte[] b, int off, int len);
  public native int c_sendbyte(int sockFD, int b);
  public native int c_close(int sockFD);

 /** 
 *  Constructor 
 **/ 
  public
  NiceSocketOutputStream(int sockFD){
    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }

    this.sockFD = sockFD;
  }

 /** 
 *  Closes this output stream and releases any system resources 
 *  associated with this stream. 
 **/ 
  public void
  close() throws IOException{
    int retVal = 0;

    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }


    retVal = c_close(this.sockFD);
    if(retVal < 0){
      throw(new IOException("Error closing socket"));
    }
  }

 /** 
 *  Flushes this output stream and forces any buffered output bytes to be 
 *  written out. 
 **/ 
  public void
  flush(){
    // Do nothing
  }

 /** 
 *  Writes b.length bytes from the specified byte array to this output 
 *  stream. 
 **/ 
  public void
  write(byte[] b) throws IOException{
    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }

    this.write(b, 0, b.length);
  }

 /** 
 *  Writes len bytes from the specified byte array starting at offset 
 *  off to this output stream. 
 **/ 
  public void
  write(byte[] b, int off, int len) throws IOException{
    int retVal = 0;

    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }

    retVal = c_send(this.sockFD, b, off, len);
    if(retVal < 0){
      throw(new IOException("Could not write to socket"));
    }
  }

 /** 
 *  Writes the specified byte to this output stream. 
 **/ 
  public void
  write(int b) throws IOException{
    int retVal = 0;

    if(!NiceSocketImpl.cSupportsNice){
      // Note: For windows compatibility the NiceSocketImpl
      // and NiceServerSocket will return plain-vanilla
      // sockets and this code will never be called. 
      assert(false);
    }

    retVal = c_sendbyte(this.sockFD, b);
    if(retVal < 0){
      throw(new IOException("Could not write to socket"));
    }
  }

 /** 
 *  Protected data 
 **/ 
  int sockFD;
}
