package code;
 /** 
 *  Represent a pool of tpc nice streams 
 **/ 
import java.util.Hashtable;

public class NiceStreamPool{
  private Hashtable ht;
  private NodeId myNodeId;
  //
  // Because of network latencies, locking is a bit weird.
  // the public method (send) is not synchronized
  // helper functions accessing the hash table are synchronized
  // the streams themselves are also synchronized
  //

 /** 
 *  Constructor 
 **/ 
  public
  NiceStreamPool(NodeId myid){
    ht = new Hashtable();
    myNodeId = myid;
  }

 /** 
 *  Send msg to the machine with address dns:port 
 **/ 
  public void
  send(String dns, int port, Object msg) throws UnableToConnectException{
    NetAddr netAddr = new NetAddr(dns, port);
    NiceReconnectConnection rc = getReconnectConnection(netAddr);
    rc.send(msg);
  }

 /** 
 *  Return a new ReconnectConnection object 
 **/ 
  private synchronized NiceReconnectConnection
  getReconnectConnection(NetAddr netAddr) throws UnableToConnectException{
    NiceReconnectConnection rc = (NiceReconnectConnection)ht.get(netAddr);

    if(rc == null){
      rc = new NiceReconnectConnection(netAddr, myNodeId);
      ht.put(netAddr, rc);
    }
    return rc;
  }
}

//---------------------------------------------------------------------------
/* $Log: NiceStreamPool.java,v $
/* Revision 1.3  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.2  2005/03/13 09:48:12  nayate
/* Added code to work with TCP-LP
/*
/* Revision 1.1  2005/02/28 20:25:59  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/* */
//---------------------------------------------------------------------------
