package code;
 /** 
 *  NodeId: Used to store a Node ID 
 **/ 
import java.io.Serializable;

public class NodeId implements Comparable, Serializable, Immutable
{
    private final long _id;
	
    // Note: assume that there's no normal minus id
    protected final static long COMMIT_PSEUDO_NODE = -1;
    protected final static long UNBIND_PSEUDO_NODE = -2;
    protected final static long INVALID_NODE_ID = -3;
    protected final static long WILDCARD_NODE_ID = -4;
    protected final static long DEBARGO_PSEUDO_NODE = -5;
    
 /** 
 *  Constructor 
 **/ 
    public NodeId(long id)
    {
	_id = id;
    }

 /** 
 *  Compare two node ids 
 *  
 *  NOTE: For use with PreciseInv, ImpreciseInv, etc. this method 
 *        must return {-1,0,1} only. 
 **/ 
    public int compareTo(Object o)
    {
	int result = 0;
	NodeId ni2 = (NodeId)o;

	if(this._id != ni2._id){
	    result = (this._id < ni2._id) ? -1 : 1;
	}else{
	    result = 0;
	}
	return(result);
    }

    /* overrides equals in class object */
    public boolean equals(Object nid){
      if(nid == null){
        return false;
      }
        if(_id == ((NodeId)nid).getIDint()){
            return true;
        }
        return false;
    }

 /** 
 *  geq() -- return true if this node is at least nid 
 **/ 
public boolean geq(NodeId nid){
  int result = this.compareTo(nid);
  if(result >= 0){
    return true;
  }
  return false;
}
 /** 
 *  leq() -- return true if this node is at most nid 
 **/ 
public boolean leq(NodeId nid){
  int result = this.compareTo(nid);
  if(result <= 0){
    return true;
  }
  return false;
}

 /** 
 *  gt() -- return true if this node is greater than nid 
 **/ 
public boolean gt(NodeId nid){
  int result = this.compareTo(nid);
  if(result > 0){
    return true;
  }
  return false;
}

 /** 
 *  lt() -- return true if this node is less than than nid 
 **/ 
public boolean lt(NodeId nid){
  int result = this.compareTo(nid);
  if(result < 0){
    return true;
  }
  return false;
}
    
    /* overrides hashCode in class object */
    public int hashCode(){
        Long value = new Long(_id);
        return value.hashCode();
    }
    
    /* override toString in class object */
    public String toString(){
        return (""+_id);
    }
    
    public long getIDint(){
        return _id;
    }

    public boolean isValid()
    {
	if(_id >= 0 || _id == WILDCARD_NODE_ID){
	    return true;
	}
	return false;
    }

  //
  // Valid and not a wildcard
  //
    public boolean isValidAndConcrete()
    {
	if(_id >= 0){
	    return true;
	}
	return false;
    }

    public Object clone()
    {
      assert(this instanceof Immutable);
      return this;
    }
    
 /** 
 *  Used for testing 
 **/ 
    public static void main(String[] argv)
    {
      System.err.print("Use junit for testing!");
      System.exit(0);
    }
}

//---------------------------------------------------------------------------
/* $Log: NodeId.java,v $
/* Revision 1.18  2006/08/15 21:46:24  dahlin
/* Added PicShare Reader and a simple unit test.
/*
/* Revision 1.17  2005/07/18 05:10:23  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.16  2005/06/09 06:56:55  nayate
/* Port code to junit
/*
/* Revision 1.15  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.14  2004/09/16 15:40:13  dahlin
/* Added leq and gt functions
/*
/* Revision 1.13  2004/08/18 22:44:44  dahlin
/* Made BoundInval subclass of PreciseInval; RandomAccessState passes 2 self tests
/*
/* Revision 1.12  2004/07/28 14:27:35  dahlin
/* Added sanity checks for immutable objects
/*
/* Revision 1.11  2004/05/10 22:45:47  dahlin
/* All unit: target tests succeed
/*
/* Revision 1.10  2004/05/10 08:47:15  nayate
/* Finished testing after converting visual test cases to asserts
/*
/* Revision 1.9  2004/05/09 19:17:31  dahlin
/* Updated NodeId self tests
/*
/* Revision 1.8  2004/05/09 02:24:16  dahlin
/* Complete coding and unit testing of InvalSpanningList and SubscribeInvalRequest
/*
/* Revision 1.7  2004/05/08 22:18:57  dahlin
/* Partially complete version of SDIMSController (it should compile w/o error, though)
/*
/* Revision 1.6  2004/04/21 17:37:41  zjiandan
/* Miner Change to make UpdateLog.java compile successfully.
/*
/* Revision 1.5  2004/04/20 04:40:03  nayate
/* Tested NodeId
/*
/* Revision 1.4  2004/04/19 23:30:04  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.3  2004/04/18 07:15:57  nayate
/* Added a method to GeneralInv, finished (but didn't test) PreciseInv
/*
/* Revision 1.2  2004/04/16 20:54:27  lgao
/* The initial implementation of NodeId class override several basic functions of the Object class
/*
/* Revision 1.1  2004/04/16 16:05:16  nayate
/* Subset of PreciseInv implemented + removed some compiler errors.
/* */
//---------------------------------------------------------------------------
