package code;
 /** 
 *  ObjNotFoundException : Thrown when an object is not found 
 **/ 
public class ObjNotFoundException extends Exception
{
    private String errStr;

 /** 
 *  Constructor 
 **/ 
    public ObjNotFoundException(String errorString)
    {
	this.errStr = errorString;
    }

 /** 
 *  Constructor 
 **/ 
    public ObjNotFoundException()
    {
	this.errStr = "Object Not found exception!";
    }

 /** 
 *  Convert this exception to a string 
 **/ 
    public String toString()
    {
	return(this.errStr);
    }
}

/* $Log: ObjNotFoundException.java,v $
/* Revision 1.3  2004/10/22 20:46:55  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.2  2004/04/30 19:23:59  nayate
/* Changed methods to print more error information
/*
/* Revision 1.1  2004/04/23 19:22:26  nayate
/* Added ObjNotFoundException
/* */
 
