package code;
//---------------------------------------------------------------------------
/* OutgoingBodyConnectionScanUnit
 *
 *  Tests the OutgoingBodyConnectionClass
 *   
 *   we assume that there is only one body connection to a destination
 *
 *  we have this in a separate file because it seems that 
 *  shutdown doesn't work very properly
 *
 *
 * (C) Copyright -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;


public class OutgoingBodyConnectionScanUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals

  private NodeId senderId = new NodeId(1);
  private NodeId receiverId = new NodeId(0); 


  private OutgoingBodyConnection oc;
  private RMIClient rmiClient1;
  private RMIClient rmiClient2;
  private SocketServer socketServer1;
  private SocketServer socketServer2;
  private Core fakeCore1;
  private Core fakeCore2;
  private Controller controller1;
  private Controller controller2;
  private LocalInterface li2;
  private LinkedList receiverEvents;
  private LinkedList senderEvents;

//---------------------------------------------------------------------------
//  Basic Constructor - called by test runners
//---------------------------------------------------------------------------

  public OutgoingBodyConnectionScanUnit(final String s){
    super(s);
  }
  
//---------------------------------------------------------------------------
//  Set up environment in which tests must run
//---------------------------------------------------------------------------
  protected void setUp() throws Exception {
    super.setUp();

   //Env.verifyAssertEnabled();
    System.out.println("Testing OutgoingBodyConnectionScan.java...");
    
    makePractiConfig();

    //Initialize sender
    rmiClient1 = new RMIClient();
    fakeCore1 = new Core(rmiClient1, false, true, senderId, false);
    fakeCore1.testSkipRecoverLocalState();
    controller1 = new LocalController(fakeCore1);
    StreamPool prefetchStreams1 = new StreamPool(fakeCore1.getMyNodeId());
    socketServer1 = new SocketServer(fakeCore1, controller1);


    //Initialize receiver
    rmiClient2 = new RMIClient();
    fakeCore2 = new Core(rmiClient2, false, true, receiverId, false);
    fakeCore2.testSkipRecoverLocalState();
    controller2 = new LocalController(fakeCore2);
    socketServer2 = new SocketServer(fakeCore2, controller2);
    li2 = new LocalInterface(controller2, fakeCore2);
    

    OutgoingConnectionPool invalConnectionPool = null;
    OutgoingInvalConnectionPool invalConPool = null;
    
    // set up inval subscription
    // OutgoingConnectionPool invalPool 
    if(!Core.useNewIterator){
      invalConnectionPool = new OutgoingConnectionPool(fakeCore1, controller1);
    }else{
      invalConPool = new OutgoingInvalConnectionPool(fakeCore1, controller1);
    }
    SubscriptionSet allSet = SubscriptionSet.makeSubscriptionSet("/*");
    if(!Core.useNewIterator){
      invalConnectionPool.addToConnection(receiverId, 
                                        Config.getDNS(receiverId), 
                                        Config.getPortInval(receiverId), 
                                        allSet,
                                        AcceptVV.makeVVAllNegatives(),
                                        false, 
					false);
    }else{
      invalConPool.addToConnection(receiverId, 
          Config.getDNS(receiverId), 
          Config.getPortInval(receiverId), 
          allSet,
          AcceptVV.makeVVAllNegatives(),
          false, 
          false);
    }

    oc = new OutgoingBodyConnection(prefetchStreams1,						  
                                    fakeCore1, 
                                    controller1,
                                    receiverId,
                                    Config.getDNS(receiverId),
                                    Config.getPortBody(receiverId));
   
  }

//---------------------------------------------------------------------------
// Clearing up after test is over
//---------------------------------------------------------------------------
  protected void tearDown() throws Exception {
    try{
      socketServer1.shutdown();
      socketServer1 = null;
      socketServer2.shutdown();
      socketServer2 = null;
      fakeCore1.syncStateToDisk();
      fakeCore1.close();
      fakeCore1 = null;
      fakeCore2.syncStateToDisk();
      fakeCore2.close();
      fakeCore2 = null;
      super.tearDown();
      Thread.currentThread().sleep(500);
    }catch(Exception e) {
      //ignore
    }

  }

//---------------------------------------------------------------------------
// Test scanning RAS when startVV is set to smaller than cVV
//---------------------------------------------------------------------------
  public void testScan() {
    oc.start();
    try{
      Thread.sleep(1000);
    }catch(Exception e){
    }

    int numFiles = 5;
    int numChunks = 5;
    int sizeOfChunk = 10;
    byte val = 65;

    //make writes
    ObjId objId = null;
    for(int i=0; i<numFiles; i++){
      for(int j=0; j<numChunks; j++) {
        objId = new ObjId("/test/" + i);
        oc.testWriteUnBound(objId, j*sizeOfChunk, sizeOfChunk, val);
      }
    }
    
    
    //establish body subscription
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/test/*");
    oc.addSubscriptionSet(ss, AcceptVV.makeVVAllNegatives());

    //Node 2 does reads to make sure it gets all the bodies
    for(int i=0; i<numFiles; i++){
      objId = new ObjId("/test/" + i);
      for(int j=0; j<numChunks; j++){
        checkReadObj(li2, objId, j*sizeOfChunk, sizeOfChunk, val);
      }       
    } 
  }

  private void checkReadObj(LocalInterface li, ObjId objId, long offset, 
                          int len, byte val){
    byte b[] = new byte[len];
    for(int ii=0; ii<len; ii++){
      b[ii] = val;
    }
    
    int numTries = 0;
    while(true) {
      try{
        if(vverbose) Env.sprintln("Trying to read " + objId + ":" + offset + ":" + len);
        ImmutableBytes imb = (li.read(objId, offset, len, true, true)).getBody();
        if(vverbose) {
          Env.sprintln("Expecting: " + new String(b));
          Env.sprintln("Read: " + imb);
        }
        assert(imb.equals(new ImmutableBytes(b))):"Value read does not match expected value";
        break;
      }catch(ObjNotFoundException e){
        // initial inval hasn't arrived yet wait and retry again
        if(numTries > 5) {
          assert(false):"Inval took too long to arrive";
        }
        try{
        Thread.currentThread().sleep(1000);
        }catch(InterruptedException ie) {}
      }catch(EOFException e) {
         // inval hasn't arrived yet wait and retry again
        if(numTries > 5) {
          assert(false):"Inval took too long to arrive";
        }
        try{
        Thread.currentThread().sleep(1000);
        }catch(InterruptedException ie) {}
      
      }catch(ReadOfInvalidRangeException e){
        //should not happen
        assert(false):"Unexpected ReadOfInvalidRangeException";
      }catch(ReadOfHoleException e) {
        //should not happen
        assert(false):"Unexpected ReadOfHoleException";
      }catch(IOException e){
        System.err.println("Unexpected IOException");
        e.printStackTrace();
        assert(false):"Unexpected IOException";
      }
      numTries++;
    }
  }
      
//---------------------------------------------------------------------------
//  Makes the config file for the experiment
//---------------------------------------------------------------------------
  private static void makePractiConfig(){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9388,
                            9389,
                            9391,
                            9392,
                            9390,
                            "OutgoingBodyConnectionScanUnit-node0.db",
                            "/*",
                            -1L,
                            "localhost",
                            9393,
                            9394,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(1),
			   "localhost",
			   9288,
			   9289,
			   9291,
			   9292,
			   9290,
                           "OutgoingBodyConnectionScanUnit-node1.db",
			   "/*",
			   -1L,
			   "localhost",
			   9293,
			   9294,
			   -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

  }
	

  public static Test suite(){
    TestSuite suite = new TestSuite(OutgoingBodyConnectionScanUnit.class);
    return suite;
  }

  public static void main(String s[]) {
    String name = "OutgoingBodyConnectionScanUnit";
    System.err.println(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
         vverbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new OutgoingBodyConnectionScanUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}
//---------------------------------------------------------------------------    
/* $Log: OutgoingBodyConnectionScanUnit.java,v $
/* Revision 1.8  2007/07/02 21:05:11  nalini
/* added wait for EOFException in outgoingbodyconnectionscanunit
/*
/* Revision 1.7  2007/06/25 05:21:29  zjiandan
/* Cleanup OutgoingConnection and add unit tests
/*
/* Revision 1.6  2007/06/04 21:40:59  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.5  2007/06/04 16:53:40  nalini
/* added more debugging output for assert failures
/*
/* Revision 1.4  2007/05/30 20:30:19  dahlin
/* Added checkpoint to SubscribeBWUnit. Changed outgoingconnection checkpoint send to not send body by default. Told barrier to close sockets when done with them.
/*
/* Revision 1.3  2007/05/11 21:07:09  nalini
/* fixed outgoing body connection, so that it tries multiple reads to send the whole range of the metabody received from upq
/*
/* Revision 1.2  2007/05/11 19:36:52  nalini
/* updated OutgoingConnectionScanUnit
/*
/* Revision 1.1  2007/05/11 02:14:29  nalini
/* updated outgoing body subscription so that it sends bodies from startVV
/* 
*/
//---------------------------------------------------------------------------
