package code;
/* OutgoingBodyQueue
 * 
 *  - assoicated with an outgoing body connection
 *  - has an internal queue to hold bodyStream control & body messages
 *  - uses update priority queue to get updated bodies
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */


import java.util.*;
import java.lang.*;

public class OutgoingBodyQueue {
  private LinkedList _list; // holds bodyStream control messages
  private UpdatePriorityQueue upq; //gets new bodies from core
  private UpdatePriorityQueueWatcher upqWatcher; // transfer bodies from upq to
                                                 // bQueue

  private boolean dbg = false;

 /** 
 *  Constructor 
 **/ 

  public OutgoingBodyQueue(UpdatePriorityQueue upq) {
    this._list = new LinkedList();
    this.upq = upq;
    this.upqWatcher = new UpdatePriorityQueueWatcher(upq, this);
    this.upqWatcher.start();
  }

 
 /** 
 *  grab lock; adds objects to the queue 
 **/ 

  public synchronized void
  add(Object obj) {
    _list.add(obj);
    notifyAll();
    if( dbg ){
      Env.dprintln(dbg, "OutgoingBodyQueue: " + obj + " added to queue");
    }
  }

 /** 
 *  get next 
 *  - wait until an object is available and remove it from the queue 
 **/ 

  public synchronized Object
  getNext() {
    if( dbg ){
      Env.dprintln(dbg, "OutgoingBodyQueue: waiting to get next from Queue");
    }
    while(_list.size() == 0 ){
      try {
        upqWatcher.transfer(); //tells watcher we want to get bodies from upq
        wait();
      }
      catch(InterruptedException e) {
      }
    }
//    Env.dprintln(dbg, "OutgoingBodyQueue: Queue not empty - getting the first item");
    assert(_list.size() > 0);
      return _list.removeFirst();
  }

 /** 
 *  isEmpty 
 **/ 
  public synchronized boolean
  isEmpty(){
    if(_list.size() > 0){
      return false;
    }
    return true;
  }
}

//---------------------------------------------------------------------------
/* $Log: OutgoingBodyQueue.java,v $
/* Revision 1.2  2007/04/02 21:11:38  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.1  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
 */
//---------------------------------------------------------------------------