package code;
 /** 
 *  Template for writing JUnit tests. To write the test for class 
 *  Foo, copy this file to FooUnit.java and update as described 
 *  below. 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.io.File;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.Enumeration;

/**
 * TBD: Update class name
 */
public class OutgoingConnectionUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public OutgoingConnectionUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
      */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }

 
 /** 
 *  Test basic functions 
 **/ 
  public void testBasics(){
    boolean DBG_OC_ONLY = false;
    OutgoingConnectionWorker.setDbgWithFileOutputStream(true);
    makePractiConfig();
    //create ISStatus as "/apple:/banana:/cherry"
    //       with interestRegion of "/*"
    PreciseSet ps = null;
    PreciseSet newPS = null;
    PreciseSet newPS2 = null;
    PreciseSet newChildPS = null;
    ps = new PreciseSet("", "");
    newPS = new PreciseSet("apple", "/apple");
    newPS2 = new PreciseSet("cherry", "/cherry");
    newChildPS = new PreciseSet("banana", "/banana");
    
    ps.children.put("apple", newPS);
    ps.children.put("cherry", newPS2);
    ps.children.put("banana", newChildPS);
      
    assert(ps.getChild("apple") == newPS);
    assert(ps.getChild("cherry") == newPS2);
    assert(ps.getChild("banana") == newChildPS);

    AllPreciseSets aps = new AllPreciseSets(ps);
    ISStatus isStatus = new ISStatus(aps, new InterestRegion("/*"));
    RMIClient rmiClient = new RMIClient();



    AcceptStamp[] as1, as2;
    AcceptVV vv1, vv2;
    
    int index1 = -1;
    int index2 = -1;
    ArrayList vec1 = new ArrayList();//verify OutgoingConnection1
    ArrayList vec2 = new ArrayList();//verify OutgoingConnection2
    
    byte appleByte = 35;
    byte bananaByte = 36;
    byte cherryByte = 37;
    

    //
    //  (1) create two OutgoingConnections : 
    //      oc  = 0 --> 1
    //      oc2 = 0 --> 2
    //
    NodeId myId = new NodeId(0);
    NodeId receiverId1 = new NodeId(1); 
    NodeId receiverId2 = new NodeId(2); 
    Core fakeCore = new Core(rmiClient, 
			     false, //filterOn
			     true,  //cleanDb,
			     myId, 
			     false);//noSyncLog

    fakeCore.setMaxAccumulateTime(10000);
    fakeCore.testSkipRecoverLocalState();
    Controller controller = new LocalController(fakeCore);
    OutgoingConnection oc = new OutgoingConnection(fakeCore, 
                                                   controller,
                                                   receiverId1,
                                                   Config.getDNS(receiverId1),
                                                   Config.getPortInval(receiverId1));
    

    OutgoingConnection oc2 = new OutgoingConnection(fakeCore, 
                                                    controller,
                                                    receiverId2,
                                                    Config.getDNS(receiverId2),
                                                    Config.getPortInval(receiverId2));
    
    assert oc.hasNoWorker();
    assert oc2.hasNoWorker();




    

    //
    //  (2) oc2 subscribes /cherry LOG
    //      
    //  (3) write /apple  <"0", 0>
    //      write /banana <"0", 1>
    //      write /cherry <"0", 2>
    //
    //      make sure that oc2 sends ImpreciseInv </apple:/banana, 0, 1>
    //                         sends PreciseInv   </cherry, 2>
    // 
    if(!DBG_OC_ONLY){
      oc2.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/cherry"), 
                             AcceptVV.makeVVAllNegatives(),
                             true,//includeBodiesIFCPSent
                             false);//catchupWithCP
    }
    testWriteUnBound("/apple", 0, 5, appleByte, fakeCore);
    testWriteUnBound("/banana", 0, 5, bananaByte, fakeCore);
    testWriteUnBound("/cherry", 0, 5, cherryByte, fakeCore);
    if(!DBG_OC_ONLY){
      index2++;
      vec2.add(index2, new Long(SocketMagicConstant.INVAL_SOCKET_MAGIC));//0
      index2++;
      vec2.add(index2, fakeCore.getMyNodeId());//1
      index2++;
      vec2.add(index2, AcceptVV.makeVVAllNegatives());//2
      index2++;
      vec2.add(index2, 
               new CatchupStreamStartMsg(SubscriptionSet.makeSubscriptionSet("/cherry"), 
				       AcceptVV.makeVVAllNegatives()));//3
      index2++;
      vec2.add(index2,new CatchupStreamEndMsg());//4
    
    
    
      as1 = new AcceptStamp[1];
      as2 = new AcceptStamp[1];
      as1[0] = new AcceptStamp(0, myId);
      as2[0] = new AcceptStamp(1, myId);
      index2++;
      vec2.add(index2, //5
               new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/apple:/banana"),
			      new AcceptVV(as1), new AcceptVV(as2)));
    
      index2++;//6
      vec2.add(index2, new PreciseInv(new ObjInvalTarget(new ObjId("/cherry"), 0, 5),
				      new AcceptStamp(2, myId)));
    
    }

    //
    //  (4) oc subscribes /apple, /banana LOG
    //
    //      wait for the subscribe requests to be taken care of
    //      
    //      make sure that oc 
    //           sends a catchupStream with PreciseInv </apple, 0>
    //           sends a catchupStream with PreciseInv </banana, 1>
    //
    oc.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple"), 
			  AcceptVV.makeVVAllNegatives(),
                          true, false);
    oc.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/banana"), 
			  AcceptVV.makeVVAllNegatives(),
                          true, false);
    assert !oc.hasNoWorker();
    if(!DBG_OC_ONLY){
      assert !oc2.hasNoWorker();
    }
    try{
      Thread.sleep(1000);
    }catch(Exception e){
      //ignore
    }
    while((oc.countPending() > 0)||(oc2.countPending() > 0)){
      try{
	Thread.sleep(1000);
      }catch(Exception e){
	//ignore
      }
    }
    
    index1++;
    vec1.add(index1, new Long(SocketMagicConstant.INVAL_SOCKET_MAGIC));//0
    index1++;
    vec1.add(index1, fakeCore.getMyNodeId());//1
    index1++;
    vec1.add(index1, fakeCore.getCurrentVV());//2
    index1++;
    vec1.add(index1, 
	     new CatchupStreamStartMsg(SubscriptionSet.makeSubscriptionSet("/apple"), 
				       AcceptVV.makeVVAllNegatives()));//3
    index1++;//4
    vec1.add(index1, new PreciseInv(new ObjInvalTarget(new ObjId("/apple"), 0, 5),
				    new AcceptStamp(0, myId)));
    
    index1++;
    vec1.add(index1,new CatchupStreamEndMsg());//5

    index1++;
    vec1.add(index1, 
	     new CatchupStreamStartMsg(SubscriptionSet.makeSubscriptionSet("/banana"), 
				       AcceptVV.makeVVAllNegatives()));//6
    index1++;//7
    vec1.add(index1, new PreciseInv(new ObjInvalTarget(new ObjId("/banana"), 0, 5),
				    new AcceptStamp(1, myId)));
    
    index1++;
    vec1.add(index1,new CatchupStreamEndMsg());//8


    //
    // (5) write /apple, <"0", 3>
    //     
    //     make sure that oc&&oc2 sends the invalidate in the main stream
    //
    AcceptVV beforeSecondAppleWrite = fakeCore.getCurrentVV();
    testWriteUnBound("/apple", 0, 5, appleByte, fakeCore);

    index1++;//9
    vec1.add(index1, new PreciseInv(new ObjInvalTarget(new ObjId("/apple"), 0, 5),
				    new AcceptStamp(3, myId)));
    if(!DBG_OC_ONLY){
      index2++;//7
      vec2.add(index2, new PreciseInv(new ObjInvalTarget(new ObjId("/apple"), 0, 5),
				    new AcceptStamp(3, myId)));

      //
      // (6) oc2 subscribes /banana with LOG
      //
      //     make sure that oc2 
      //          sends a catchupStream PreciseInv </banana, 1>
      //
      oc2.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/banana"), 
			   AcceptVV.makeVVAllNegatives(),
                           true, false);//with Log
    
      index2++;
      vec2.add(index2, 
	     new CatchupStreamStartMsg(SubscriptionSet.makeSubscriptionSet("/banana"), 
				       AcceptVV.makeVVAllNegatives()));//8
      index2++;
      vec2.add(index2, new PreciseInv(new ObjInvalTarget(new ObjId("/banana"), 0, 5),
				    new AcceptStamp(1, myId)));//9
    
      index2++;
      vec2.add(index2,new CatchupStreamEndMsg());//10
    }
    
    //
    //     (7) oc subscribes /cherry with CP
    //
    //     make sure that oc sends a CP for /cherry with cvv=lpvv=3
    //
    oc.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/cherry"), 
			  AcceptVV.makeVVAllNegatives(),
                          true, true); //with CP
    Vector lpvvRecsToSend = new Vector();
    lpvvRecsToSend.add(new LPVVRecord("/cherry", 
				      fakeCore.getCurrentVV(), 
				      fakeCore.getCurrentVV()));
    index1++;
    vec1.add(index1, new CPStartMsg(SubscriptionSet.makeSubscriptionSet("/cherry"),
				    AcceptVV.makeVVAllNegatives(),
				    fakeCore.getCurrentVV(),
				    lpvvRecsToSend));//10
    
    
    
    index1++;
    try{
      vec1.add(index1, fakeCore.read(new ObjId("/cherry"), 0, 5, true, true, true, -1));//13
    }catch(Exception e){
      assert false;
    }
    index1++;
    vec1.add(index1, new Long(RandomAccessState.RAS_SHIP_DONE));//14

    if(!DBG_OC_ONLY){
      //
      //     (8) oc2 subscribes /apple with startVV= <"0", 2>
      //
      //     wait until all requests served
      //
      //     make sure that oc2 
      //          sends a catchupstream PreciseInv </apple, 3>
      //
      oc2.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/apple"), 
			   beforeSecondAppleWrite,
                           true, false);//withLOG
      index2++;
      vec2.add(index2, 
  	     new CatchupStreamStartMsg(SubscriptionSet.makeSubscriptionSet("/apple"), 
  				       beforeSecondAppleWrite));//11
      index2++;
      vec2.add(index2, new PreciseInv(new ObjInvalTarget(new ObjId("/apple"), 0, 5),
  				    new AcceptStamp(3, myId)));//12
      
      index2++;
      vec2.add(index2,new CatchupStreamEndMsg());//13
    }
    try{
      Thread.sleep(1000);
    }catch(Exception e){
      //ignore
    }
    while((oc.countPending() > 0)||(oc2.countPending() > 0)){
      try{
        Thread.sleep(1000);
      }catch(Exception e){
        //ignore
      }
    }

    
    if(!DBG_OC_ONLY){
      //
      // (9) oc2 subscribe /banana with CP, startVV = <"0", 3>
      //     make sure that oc2 sends a CP with no bodymsg
      //     
      oc2.addSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/banana"), 
  			   fakeCore.getCurrentVV(),
                             true, true);
      
      index2++;
      vec2.add(index2, new CPStartMsg(SubscriptionSet.makeSubscriptionSet("/banana"),
  				    fakeCore.getCurrentVV(),
  				    fakeCore.getCurrentVV(),
  				    new Vector()));//14
      
      
      index2++;
      vec2.add(index2, new Long(RandomAccessState.RAS_SHIP_DONE));//17
    }

    //
    // (10) oc removes /banana:/cherry
    //     write /banana <"0", 4>
    //     write /cherry <"0", 5>
    //
    //     wait for quience
    //     make sure that oc sends ImpreciseInv </banana:/cherry, 4, 5>
    //     make sure that oc2 sends PreciseInv </banana, 4>
    //                        sends PreciseInv </cherry, 5> 
    //                        in the main stream
    //
    
    oc.removeSubscriptionSet(SubscriptionSet.makeSubscriptionSet("/banana:/cherry"));

    try{
      Thread.sleep(10000);
    }catch(Exception e){
      //ignore
    }
    
    
    testWriteUnBound("/banana", 0, 5, bananaByte, fakeCore);
    testWriteUnBound("/cherry", 0, 5, cherryByte, fakeCore);

    try{
      Thread.sleep(10000);
    }catch(Exception e){
      //ignore
    }
    
    OutgoingConnectionWorker.setDbgWithFileOutputStream(false);
    if(!DBG_OC_ONLY){
      oc2.close();
    }
    oc.close();
    try{
      Thread.sleep(2000);
    }catch(Exception e){
      //ignore
    }
    Thread.yield();
    
    if(!DBG_OC_ONLY){
      index2++;
      vec2.add(index2, new PreciseInv(new ObjInvalTarget(new ObjId("/banana"), 0, 5),
  				    new AcceptStamp(4, myId)));//18
      
      index2++;
      vec2.add(index2, new PreciseInv(new ObjInvalTarget(new ObjId("/cherry"), 0, 5),
  				    new AcceptStamp(5, myId)));//19
    }
    
    index1++;
    as1 = new AcceptStamp[1];
    as2 = new AcceptStamp[1];
    as1[0] = new AcceptStamp(4, myId);
    as2[0] = new AcceptStamp(5, myId);
    vec1.add(index1, //15
	     new ImpreciseInv(HierInvalTarget.makeHierInvalTarget("/banana:/cherry"),
			      new AcceptVV(as1),
			      new AcceptVV(as2)));

    
    index2++;
    if(!DBG_OC_ONLY){
      vec2.add(index2, new TerminateMsg());
    }
    index1++;
    vec1.add(index1, new TerminateMsg());

    String outFile1 = OutgoingConnectionWorker.outFilePrefix 
      + myId + "_" + receiverId1 +".out";
    verifyOutputFile(outFile1, vec1);
    
    String outFile2 = OutgoingConnectionWorker.outFilePrefix 
      + myId + "_" + receiverId2 +".out";
    if(!DBG_OC_ONLY){
      verifyOutputFile(outFile2, vec2);
    }
    
  }

  //----------------------------------------------------------------------
  //----------------------------------------------------------------------
  // unit test helper functions
  //----------------------------------------------------------------------
  //----------------------------------------------------------------------

  //----------------------------------------------------------------------
  // verify the given outputstream file has the same stuff in the same order
  // as in the vector
  //----------------------------------------------------------------------
  private void verifyOutputFile(String outputFileName, ArrayList objList){
    try{
	File tmpFile = new File(outputFileName);
	assert tmpFile.exists();
        assert tmpFile.isFile();
    }catch(Exception e){
	System.err.println("delete tmp file error: " + e.toString());
        e.printStackTrace();
        assert false;
    }
    int index = 0;
    try{
      FileInputStream fis = new FileInputStream(outputFileName);
      TaggedInputStream tis = new TaggedInputStream(fis);   
      
      for (int i = 0; i < objList.size(); i++) {
	
	Object expto = objList.get(i);
        Object streamo = tis.readTaggedObject();
        if (expto instanceof PerObjStateForSend){
          assert ((PerObjStateForSend)expto).equals(streamo);
        }else if (expto instanceof PerRangeStateForSend){
          assert ((PerRangeStateForSend)expto).equals(streamo);
	}else if (expto instanceof BodyMsg){
	  assert ((BodyMsg)expto).equals(streamo);
        }else if(expto instanceof Long){
          assert ((Long)expto).equals(streamo):"streamo=" + streamo 
	    + "\n expto= " + expto;
	}else if(expto instanceof NodeId){
	  assert ((NodeId)expto).equals(streamo);
	}else if(expto instanceof AcceptVV){
	  assert ((AcceptVV)expto).equalsIgnoreNegatives(streamo);
	}else if(expto instanceof CatchupStreamStartMsg){
	  assert ((CatchupStreamStartMsg)expto).equals(streamo);
	}else if(expto instanceof CatchupStreamEndMsg){
	  assert ((CatchupStreamEndMsg)expto).equals(streamo);
	}else if(expto instanceof ImpreciseInv){
	  assert ((ImpreciseInv)expto).equals(streamo):"i=" + i + "streamo=: " + streamo
	    + "\n expto= " + expto; 
	}else if(expto instanceof PreciseInv){
	  assert ((PreciseInv)expto).equals(streamo):"i=" + i + " streamo=" + streamo 
	    + "\n expto= " + expto;  
	}else if(expto instanceof CPStartMsg){
	  assert ((CPStartMsg)expto).equals(streamo): "expto=" + expto
	    + " streamo= " + streamo;
	}else if(expto instanceof TerminateMsg){
	  assert ((TerminateMsg)expto).equals(streamo);
	}else if(expto instanceof Vector){
	  assert (streamo instanceof Vector);
	  Vector vec1 = (Vector)expto;
	  Vector vec2 = (Vector)streamo;
	  assert vec1.size() == vec2.size();
	  for (int j = 0; j < vec1.size(); j ++){
	    assert vec1.get(j).equals(vec2.get(j))
	      :vec1.get(j) + " expected :" + vec2.get(j);
	  }
        }else{
          assert false;
        }
	index++;
      }
      tis.close();
      fis.close();
    }catch(Exception e){
      System.err.println(" while read file for index = " + index + ":" + e.toString());
      e.printStackTrace();
      assert false;
    }
    
  }

  //----------------------------------------------------------------------
  // make a Config file
  //----------------------------------------------------------------------
  private void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9911,
                            9912,
                            9913,
                            9914,
                            9915,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9916,
                            9917,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
    Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			    NODE_1_IP,
			    9811,
			    9812,
			    9813,
			    9814,
                            9815,
			    "test" + File.separatorChar + "local-" + 
			    NODE_1_ID+".db",
			    "/*",
			    -1L,
			    NODE_1_IP,
			    9816,
			    9817,
			    -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);

    Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			    NODE_2_IP,
			    9711,
			    9712,
			    9713,
			    9714,
                            9715,
			    "test" + File.separatorChar + "local-" + 
			    NODE_2_ID+".db",
			    "/*",
			    -1L,
			    NODE_2_IP,
			    9716,
			    9717,
                            -1,
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    
  }
  
  //----------------------------------------------------------------------
  // testSetBytes
  //----------------------------------------------------------------------
  private static void
  testSetBytes(byte b[], int len, byte value){
    int ii;
    for(ii = 0; ii < len; ii++){
      b[ii] = value;
    }
  }

  //----------------------------------------------------------------------
  // testWriteBound
  //----------------------------------------------------------------------
  private static void 
  testWriteBound(String path, long offset, int len, byte val, Core core){
    ObjId id = new ObjId(path);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    
    byte b[] = new byte[len];
    testSetBytes(b, len, val);
    ImmutableBytes ib = new ImmutableBytes(b);
    try{
      core.write(id, offset, len, ib, true, Long.MAX_VALUE);
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }

  //----------------------------------------------------------------------
  // testWriteUnBound
  //----------------------------------------------------------------------
  private static void 
  testWriteUnBound(String path, long offset, int len, byte val, Core core){
    ObjId id = new ObjId(path);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    
    byte b[] = new byte[len];
    testSetBytes(b, len, val);
    ImmutableBytes ib = new ImmutableBytes(b);
    try{
      core.write(id, offset, len, ib, false, 0);
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }

  //----------------------------------------------------------------------
  // testApplyBound
  //----------------------------------------------------------------------
  private static void 
  testApplyBound(String path, long node, long localStamp, long offset, int len, 
                 byte val, Core core){
    ObjId id = new ObjId(path);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    NodeId nodeId = new NodeId(node);
    AcceptStamp stamp = new AcceptStamp(localStamp, nodeId);
    int ii;
    byte b[] = new byte[len];
    testSetBytes(b, len, val);
    ImmutableBytes ib = new ImmutableBytes(b);
    BoundInval bi = new BoundInval(oit, stamp, ib);

    core.applyInval(bi, null);
  }

  //----------------------------------------------------------------------
  // testWritePI
  //----------------------------------------------------------------------
  private static void 
  testApplyPrecise(String path, long node, long localStamp, long offset, long len,
                   Core core){
    ObjId id = new ObjId(path);
    ObjInvalTarget oit = new ObjInvalTarget(id, offset, len);
    NodeId nodeId = new NodeId(node);
    AcceptStamp stamp = new AcceptStamp(localStamp, nodeId);
    PreciseInv pi = new PreciseInv(oit, stamp);
    core.applyInval(pi, null);
  }

  //----------------------------------------------------------------------
  // testWriteImprecise
  //----------------------------------------------------------------------
  private static void 
  testApplyImprecise(String path, long node, long localStart, long localEnd,
                     Core core){

    HierInvalTarget hit = HierInvalTarget.makeHierInvalTarget(path);
    PreciseSet ps = null;
    boolean isPrecise = true;
    NodeId nodeId = new NodeId(node);
    AcceptStamp start = new AcceptStamp(localStart, nodeId);
    AcceptStamp end = new AcceptStamp(localEnd, nodeId);
    AcceptStamp startStamps[] = new AcceptStamp[1];
    startStamps[0] = start;
    AcceptStamp endStamps[] = new AcceptStamp[1];
    endStamps[0] = end;
    
    AcceptVV startVV = new AcceptVV(startStamps);
    AcceptVV endVV = new AcceptVV(endStamps);
    VVMap startVVs;

    ImpreciseInv ii = new ImpreciseInv(hit,
                                       startVV,
                                       endVV);
    core.applyInval(ii, null);
  }
  
  //----------------------------------------------------------------------
  // testReadBody
  //----------------------------------------------------------------------
  private static void 
  testReadBody(String path, long offset, long len, byte val, Core core){
    ObjId id = new ObjId(path);
    BodyMsg bm;
    byte b[];
    int ii;
    try{
      bm = core.read(id, offset, len, true, true, true, -1);
      b = bm.getBody().dangerousGetReferenceToInternalByteArray();
      for(ii = 0; ii < len; ii++){
        assert(b[ii] == val);
      }
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }

  //----------------------------------------------------------------------
  // testReadInvalidRange
  //----------------------------------------------------------------------
  private static void 
  testReadInvalidRange(String path, long offset, Core core){
    ObjId id = new ObjId(path);
    try{
      core.read(id, offset, 1, false, false, true, -1);
      assert(false);
    }
    catch(ReadOfInvalidRangeException e){
      // Expected this
      return;
    }
    catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }




  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(OutgoingConnectionUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java OutgoingConnectionUnit foo" runs
   *   OutgoingConnectionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    Env.verifyAssertEnabled();
    String name = "OutgoingConnectionUnit";
    System.err.print(name + " self test begins...");
    
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new OutgoingConnectionUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}

//---------------------------------------------------------------------------
/* $Log: OutgoingConnectionUnit.java,v $
/* Revision 1.6  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.5  2007/08/05 04:43:54  zjiandan
/* SocketServer shutdown quietly
/*
/* Revision 1.4  2007/07/15 06:21:29  zjiandan
/* optimize bw for cp exchange
/*
/* Revision 1.3  2007/07/12 17:02:32  zjiandan
/* *** empty log message ***
/*
/* Revision 1.2  2007/06/29 01:01:41  zjiandan
/* *** empty log message ***
/*
/* Revision 1.1  2007/06/25 05:25:04  zjiandan
/* *** empty log message ***
/* */
//---------------------------------------------------------------------------
