//---------------------------------------------------------------------------
/* AddBodySubscripitonHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class AddBodySubscriptionHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false||P2Runtime.verboseHandlers;
 
  public AddBodySubscriptionHandler(P2Runtime runtime){
    super("addBodySubscription");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp) {
    if(dbg){
      Env.dprintln(dbg, "AddBodySubscriptionHandler: "+ tp);
    }
    // <addBodySubscription, myOverlogId, senderNode, ss>
    NodeId senderNode = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));
    
    SubscriptionSet ss;
    if(OverlogPolicy.P2VersionHasStringProblem){
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3).replaceAll("-", "/"));
    }else {
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3));
    }

    runtime.addBodySubscription(senderNode, ss);
  }
}

//---------------------------------------------------------------------------
/* $Log: AddBodySubscriptionHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------