//---------------------------------------------------------------------------
/* AddInvalSubscripitonHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class AddInvalSubscriptionHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false || P2Runtime.verboseHandlers;
  public AddInvalSubscriptionHandler(P2Runtime runtime){
    super("addInvalSubscription");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp)
    throws MalformedTupleException{
    if(dbg){
      Env.dprintln(dbg, "PRACTI receives:: AddInvalSubscriptionHandler: "+ tp);
    }
    // <addInvalSubscription, myOverlogId, senderNode, ss> or
    // <addInvalSubscription, myOverlogId, senderNode, ss, LOG|CP>

    if(tp.getLength() < 4) {
      throw new MalformedTupleException("addInvalSubscription Tuple does not have enough elements");
    }
    NodeId senderNode = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));
   
    SubscriptionSet ss;
    if(OverlogPolicy.P2VersionHasStringProblem){
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3).replaceAll("-", "/"));
    }else {
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3));
    }

    boolean catchupWithCP = false;
    if(tp.getLength() > 4 ){
      String str = tp.getItem(4);
      if(str.equalsIgnoreCase("LOG")){
        catchupWithCP = false;
      }else if (str.equalsIgnoreCase("CP")) {
        catchupWithCP = true;
      }else {
        throw new MalformedTupleException("unrecognized LOG/CP option in tuple");
      }
    }
      
    runtime.addInvalSubscription(senderNode, ss, catchupWithCP);

  }
}

//---------------------------------------------------------------------------
/* $Log: AddInvalSubscriptionHandler.java,v $
/* Revision 1.7  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.6  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.5  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.4  2007/03/09 23:01:24  zjiandan
/* Make IncommingConnection not kick off an object when receiving an impreciseinv
/* if the receiver's local lpvv is not "less" then the inv.endVV.
/*
/* Revision 1.3  2007/03/06 18:25:51  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/*
/* Revision 1.2  2007/03/02 01:35:29  zjiandan
/* Yeah! Working Simplified TierStore.
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------