//---------------------------------------------------------------------------
/* AllReadBlockAllWriteUnboundInterface.java
 * 
 *  Wrapper for LocalInterface
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.IOException;
import java.io.EOFException;

public class AllReadBlockAllWriteUnboundInterface extends LocalInterface {


//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public 
  AllReadBlockAllWriteUnboundInterface(Controller controller_, Core core_){
    super(controller_, core_);
  }

//---------------------------------------------------------------------------
//  Read Method - blocks for all invalid and imprecise reads
//---------------------------------------------------------------------------
  public ImmutableBytes
  read(ObjId objId, long offset, long length)
    throws ObjNotFoundException, IOException, 
	   EOFException, ReadOfInvalidRangeException, ReadOfHoleException {
    return super.read(objId, offset, length, true, true).getBody();
  }

//---------------------------------------------------------------------------
//  Write Method - bound writes
//---------------------------------------------------------------------------
  public long
  write(ObjId objId, 
        long offset, 
        long length, 
        byte[] buffer)
    throws IOException{
    return super.write(objId, offset, length, new ImmutableBytes(buffer), false);
  }
}
//---------------------------------------------------------------------------
/* $Log: AllReadBlockAllWriteUnboundInterface.java,v $
/* Revision 1.5  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.4  2006/12/08 23:13:18  nalini
/* reverted to old read interface
/*
/* Revision 1.2  2006/06/22 18:21:39  nalini
/* added isPrecise and isValid to LocalInterface
/*
*/
//---------------------------------------------------------------------------
