//---------------------------------------------------------------------------
/*  CmdWorkerThread
 *  
 * Takes a command from the queue and executes it
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.lang.*;

public class CmdWorkerThread extends Thread {
  private RMIClient rmiClient;
  private Core core;
  private BlockedQueue cmdQueue;
  private boolean dbg = false;
  private boolean verbose = false;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public CmdWorkerThread(RMIClient rmiClient, Core core, Status status) {
    this.rmiClient = rmiClient;
    this.core = core;
    this.cmdQueue = status.getPendingPractiCommandQueue();
  }

//---------------------------------------------------------------------------
// run - gets an item from the queue and inserts it into overlog
//---------------------------------------------------------------------------
 
  public void run(){
    while(true) {
      if(dbg){
	Env.dprintln(dbg, "CmdWorkerThread: trying to get next command from queue");
      }
      PractiCommand cmd = (PractiCommand) cmdQueue.getNext();
      try {
	if(dbg){
	  Env.dprintln(dbg, "CmdWorkerThread: got cmd from queue: " + cmd);
	}
        cmd.doCommand(rmiClient, core);
      } catch (Exception e) {
        if(dbg){
	//Exception can be ingnored (??)
        Env.dprintln(dbg, "CmdWorkerThread: Exception when handling " + cmd);
        Env.dprintln(dbg, e.toString());
        Env.dprintln(verbose, "CmdWorkerThread: Exception when handling " + cmd);
	// Env.dprintln(verbose, e.toString());
	if(verbose){
	  e.printStackTrace();
	}
	}
      }
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: CmdWorkerThread.java,v $
/* Revision 1.4  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.3  2007/03/07 20:39:07  zjiandan
/* add InvalIterator Filter.
/*
/* Revision 1.2  2007/03/06 21:26:03  nalini
/* added verbose flags so as to print out rmi exceptions
/*
/* Revision 1.1  2006/10/03 15:46:02  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
