//---------------------------------------------------------------------------
/* DebargoCmd.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------

public class DebargoCmd extends PractiCommand{
 
  private ObjId objId;
  private long offset;
  private long length;
  private AcceptStamp as;
  
  private boolean dbg = false;

//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public DebargoCmd(ObjId objId,
                    long offset,
                    long length,
                    AcceptStamp as) {
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.as = as;
  }
 
//--------------------------------------------------------------------------
// doCommand Method
//--------------------------------------------------------------------------
  public void  doCommand(RMIClient rmiClient, Core core) throws Exception {
    if(dbg){
      Env.dprintln(dbg, "DebargoCmd: Executing debargo for " + objId + ":" + offset
		   + ":" + length + ":" + as);
    }
    ObjInvalTarget objTarget = new ObjInvalTarget(objId, offset, length);
    DebargoMsg debargo = new DebargoMsg(objTarget, as);
    core.applyDebargo(debargo);
    Env.dprintln(dbg, "DebargoCmd:returned from core ");
 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "DebargoCmd :" + objId + ", " + offset + ", " + length + 
      ", " + as;
  }
}

//---------------------------------------------------------------------------
/* $Log: DebargoCmd.java,v $
/* Revision 1.5  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.4  2006/10/18 18:40:38  nalini
/* set verbose to false
/*
/* Revision 1.3  2006/10/17 23:40:55  nalini
/* minor bug fixes and separated AS into individual components in overlog tuples
/*
/* Revision 1.2  2006/10/13 20:49:31  nalini
/* minor fixes
/*
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
