//---------------------------------------------------------------------------
/* DemandRead.java
 * 
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------


public class DemandRead implements Cloneable{

  private NodeId senderNode;
  private NodeId receiverNode;
  private ObjId objId;
  private long offset;
  private long length;
  private long requestId;
  private long numTries;
    
    //add by zjd
    private AcceptStamp as;

  private static final boolean dbg = false;


//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public 
  DemandRead(NodeId senderNode, NodeId receiverNode, ObjId objId, long offset,
             long length, AcceptStamp as){
    this.senderNode = senderNode;
    this.receiverNode = receiverNode;
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.requestId = 0;
    this.numTries = 0;
    this.as = as;
  }

  public 
  DemandRead(NodeId senderNode, NodeId receiverNode, ObjId objId, long offset,
             long length, long requestId, AcceptStamp as){
    this.senderNode = senderNode;
    this.receiverNode = receiverNode;
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.requestId = requestId;
    this.numTries = 0;
    this.as = as;
  }

//---------------------------------------------------------------------------
// clone
//---------------------------------------------------------------------------
  public Object clone(){
    DemandRead r = new DemandRead((NodeId)this.senderNode.clone(),
                                  (NodeId)this.receiverNode.clone(),
                                  (ObjId)this.objId.clone(),
                                  this.offset,
                                  this.length,
                                  this.requestId,
				  (AcceptStamp)this.as.clone());
    r.numTries = this.numTries;
    return r;
  }


//---------------------------------------------------------------------------
//  get Methods
//---------------------------------------------------------------------------

  public NodeId 
  getSenderNode(){
    return this.senderNode;
  }

  public NodeId 
  getReceiverNode(){
    return this.receiverNode;
  }

  public ObjId
  getObjId(){
    return this.objId;
  }

  public long
  getOffset(){
    return this.offset;
  }

  public long
  getLength(){
    return this.length;
  }

  public long
  getRequestId(){
    return this.requestId;
  }

  public long 
  getNumTries(){
   return this.numTries;
  }

  public void 
  incNumTries(){
    this.numTries++;
  }
    
  public AcceptStamp
      getAcceptStamp(){
      return this.as;
  }

//---------------------------------------------------------------------------
// toString
//---------------------------------------------------------------------------
  public String toString(){
    return "DemandRead{sender="+senderNode.toString()
      + " recvr=" + receiverNode.toString()
      + " objId=" + objId.toString()
      + " offset=" + offset
      + " length=" + length
      + " reqId=" + requestId
      + " numTries=" + numTries
	+ " as=" + as.toString();
  }


//---------------------------------------------------------------------------
// Return ture if "o" equals this object
//    Note: we do not consider numTries in the comparison
//---------------------------------------------------------------------------
  public boolean 
  equals(Object o){

    if(this == o) {
      return true;
    }

    if(!(o instanceof DemandRead)){
      return false;
    }
    
    DemandRead d2 = (DemandRead)o;

    //
    //Note: we do not consider numTries in the comparison
    //
    
    if(this.senderNode.equals(d2.getSenderNode()) &&
       this.receiverNode.equals(d2.getReceiverNode()) &&
       this.objId.equals(d2.getObjId()) && 
       this.offset == d2.getOffset() &&
       this.length == d2.getLength() &&
       this.requestId == d2.getRequestId() &&
       this.as.equals(d2.getAcceptStamp())){
     
      Env.dprintln(dbg, "DemandRead::equals: " + this.toString() + " v " 
                 + o.toString() + " TRUE");

      return true;
    }

    Env.dprintln(dbg, "DemandRead::equals: " + this.toString() + " v " 
                 + o.toString() + " FALSE");

    return false;
  }

//---------------------------------------------------------------------------
// Testing
//---------------------------------------------------------------------------

  public static void main(String[] args){
    NodeId n1 = new NodeId((long) 1);
    NodeId n2 = new NodeId((long) 2);
    NodeId n3 = new NodeId((long) 3);
    NodeId n4 = new NodeId((long) 4);

    AcceptStamp as = new AcceptStamp(-1, new NodeId(1L));
    AcceptStamp as2 = new AcceptStamp(1, new NodeId(1L));

    ObjId obj1 = new ObjId("/a");
    ObjId obj1_b = new ObjId("/a");
    ObjId obj2 = new ObjId("/b");
    
    DemandRead dr1 = new DemandRead(n1, n2, obj1, 10, 20, 50, as);
    DemandRead dr1_b = new DemandRead(n1, n2, obj1_b, 10, 20, 50, as);
    DemandRead dr2 = new DemandRead(n1, n2, obj1, 10, 20,  100, as);

    DemandRead dr3 = new DemandRead(n1, n3, obj1, 10, 20, as);
    DemandRead dr4 = new DemandRead(n3, n2, obj1, 10, 20, as);
    DemandRead dr5 = new DemandRead(n1, n2, obj2, 10, 20, as);
    DemandRead dr6 = new DemandRead(n1, n2, obj1, 100, 20, as);
    DemandRead dr7 = new DemandRead(n1, n2, obj1, 10, 200, as);
    
    DemandRead dr8 = new DemandRead(n1, n2, obj1, 10, 200, as2);
    assert dr7.equals(dr7);
    assert !dr7.equals(dr8);
    assert !dr8.equals(dr7);

    dr1.incNumTries();
    System.out.println("DemandRead:" + dr1.getSenderNode() + " " +
                       dr1.getReceiverNode() + " " + dr1.getObjId() + " "+
                       dr1.getOffset()+ " " + dr1.getLength()+ " " +
                       dr1.getRequestId() + " " +dr1.getNumTries() + " " + dr1.getAcceptStamp().toString());

    
    if(!dr1.equals(dr1_b)){
      System.out.println("Problem in Equal - case 0");
      System.exit(-1);
    }

    if(dr1.equals(dr2)){
      System.out.println("Problem in Equal - case 1");
      System.exit(-1);
    }

    if(dr1.equals(dr3)){
      System.out.println("Problem in Equal - case 2");
      System.exit(-1);
    }


    if(dr1.equals(dr4)){
      System.out.println("Problem in Equal - case 3");
      System.exit(-1);
    }


    if(dr1.equals(dr5)){
      System.out.println("Problem in Equal - case 4");
      System.exit(-1);
    }


    if(dr1.equals(dr6)){
      System.out.println("Problem in Equal - case 5");
      System.exit(-1);
    }


    if(dr1.equals(dr7)){
      System.out.println("Problem in Equal - case 6");
      System.exit(-1);
    }
  
    System.out.println("Self test successful");
  }
    
}

//---------------------------------------------------------------------------
/* $Log: DemandRead.java,v $
/* Revision 1.6  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.5  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
*/
//---------------------------------------------------------------------------
