//---------------------------------------------------------------------------
/* DemandReadHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class DemandReadHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public DemandReadHandler(P2Runtime runtime){
    super("demandRead");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp) {
    Env.dprintln(dbg, "handleDemandRead: "+ tp);
    // <demandRead, myOverlogId, senderNode, objId, offset, length, TS, WID>
    NodeId senderNode = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));    

    ObjId objId;
    if(OverlogPolicy.P2VersionHasStringProblem){
      objId = new ObjId(tp.getItem(3).replaceAll("-", "/"));  
    }else {
      objId = new ObjId(tp.getItem(3));  
    }

    long offset = new Long(tp.getItem(4)).longValue();
    long length = new Long(tp.getItem(5)).longValue();
    AcceptStamp as = new AcceptStamp(new Long(tp.getItem(6)).longValue(), 
				     new NodeId(new Long(tp.getItem(7)).longValue()));//nodeId directly
    
    runtime.demandRead(senderNode, objId, offset, length, as);
   }
}

//---------------------------------------------------------------------------
/* $Log: DemandReadHandler.java,v $
/* Revision 1.6  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.5  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.4  2007/03/06 18:25:51  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/*
/* Revision 1.3  2007/02/27 20:53:11  zjiandan
/* correct acceptStamp interpretion from p2.
/*
/* Revision 1.2  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------