//---------------------------------------------------------------------------
/* DemandReadPolicy.java
 * 
 *  Does nothing
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;
import java.util.Hashtable;

public class DemandReadPolicy extends Policy{

  private boolean dbg = false;

  private NodeId serverNodeId;
  
  //
  // Hashtable has its own lock
  //
  private Hashtable pendingReads;

  public
  DemandReadPolicy(NodeId serverId_){
    this.serverNodeId = serverId_;
    pendingReads = new Hashtable();
  }


//---------------------------------------------------------------------------
// starts the policy layer
//---------------------------------------------------------------------------
  public void start(){
  }


//---------------------------------------------------------------------------
// shuts down the policy layer
//---------------------------------------------------------------------------
  public void shutdown(){
  }

//---------------------------------------------------------------------------
// interface to interact with safety module
//---------------------------------------------------------------------------

  // sendMsg: called by safety to send a msg to liveness policy
  public void receiveMsg(String[] msg){
  }

//---------------------------------------------------------------------------
// information of practi events
//---------------------------------------------------------------------------

  public void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval){
    Env.dprintln(dbg, "informLocalReadInvalid:"+objId+":"+offset+":"+length);
    Env.dprintln(dbg, "...going to demandRead it");

    Object prev;

    // first send the request to the original writer
    ObjInvalTarget t = new ObjInvalTarget(objId, offset, length);
    prev = pendingReads.put(t, inval.getNodeId());
    //
    // If there was no outstanding read request for this object,
    // then generate one. Note that DataStore may generate
    // multiple events per miss, so this lets us filter
    // out duplicates while stile ensuring that if the demand read
    // reply that we eventually get is not good enough, we will
    // eventually re-issue the demand read.
    //
    if(prev == null){
	runtime.demandRead(serverNodeId, objId, offset, length, inval);
    }
  }

  public void informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.dprintln(dbg, "informLocalReadImprecise:"+objId+":"+offset+":"+length);
  }

  public void informLocalWrite(ObjId objId, long offset, long length, AcceptStamp as,
                               boolean isBound, boolean isEmbargoed){
    Env.dprintln(dbg, "informLocalWrite"+objId+":"+offset+":"+length);
  }

  public void informLocalDelete(ObjId objId){
    Env.dprintln(dbg, "informLocalDelete"+objId);
  }

  public void informReceiveInval(NodeId senderNodeId, ObjId objId, long offset, long length,
                                 AcceptStamp as, boolean isBound, boolean isEmbargoed){
    Env.dprintln(dbg, "informReceiveInval"+objId+":"+offset+":"+length);
}


  public void informDemandReadSuccess(NodeId senderNodeId, ObjId objId, long offset,
				      long length,
				      AcceptStamp as) {
      Env.dprintln(dbg, "informDemandReadSuccess"+senderNodeId+":"+objId+":"+offset+":"+length 
		   + ":" + as.toString());
    ObjInvalTarget t = new ObjInvalTarget(objId, offset, length);
    pendingReads.remove(t);
    
  }

  public void informDemandReadFailedMiss(NodeId senderNodeId, ObjId objId, 
                                         long offset, long length, 
					 AcceptStamp as) {
      Env.dprintln(dbg, "informDemandReadFailedMiss"+senderNodeId+":"+objId
		   +":"+offset+":"+length + ":" + as.toString());
  }
 
  public void informDemandReadFailedMaxRetries(NodeId senderNodeId, ObjId objId, 
                                               long offset,long length,
					       AcceptStamp as) {
    Env.dprintln(dbg, "informDemandReadFailedMaxRetries"
		 +senderNodeId+":"+objId+":"+offset+":"+length + ":" + as.toString());
  }


  public void recvSyncReply(NodeId senderNodeId, AcceptStamp acceptStamp) {
    Env.dprintln(dbg, "recvSyncReply "+senderNodeId+":"+acceptStamp);
  }

//---------------------------------------------------------------------------
// Subscription add events
//---------------------------------------------------------------------------


  public void informAddedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAddedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }


  public void informAttachedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAttachedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informAddedBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informAddedOutgoingInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAddedOutgoingBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

//---------------------------------------------------------------------------
// Subscription removed events
//---------------------------------------------------------------------------

  public void informRemovedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informRemovedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedBodySbuscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }
  
  public void informRemovedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedOutgoingInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informRemovedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedOutgiongBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

//---------------------------------------------------------------------------
// Subscription failed
//---------------------------------------------------------------------------
 
  public void informAddInvalSubscriptionFailed(NodeId senderNodeId, 
                                               NodeId receiverNodeId, 
                                               SubscriptionSet ss){
    Env.dprintln(dbg, "informAddInvalSubscriptionFailed"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddBodySubscriptionFailed(NodeId senderNodeId, 
                                              NodeId receiverNodeId, 
                                              SubscriptionSet ss){
   Env.dprintln(dbg, "informAddBodySubscriptionFailed"+senderNodeId+":"+receiverNodeId+":"+ss);
  }
  
}
//---------------------------------------------------------------------------
/* $Log: DemandReadPolicy.java,v $
/* Revision 1.10  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.9  2007/03/09 21:46:09  nalini
/* added 2 events: informAddInvalSubscriptionFailed & informAddBodySubscriptionFailed
/*
/* Revision 1.8  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.7  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.6  2006/09/26 05:34:09  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.5  2006/08/24 23:08:53  nalini
/* Simple unit test created for P2Runtime
/*
*/
//---------------------------------------------------------------------------
