//---------------------------------------------------------------------------
/* InformBodyStreamTerminatedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformBodyStreamTerminatedMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformBodyStreamTerminatedMsg(NodeId senderNodeId){
    this.senderNodeId = senderNodeId;
  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informBodyStreamTerminated(senderNodeId); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformBodyStreamTerminatedMsg: " + senderNodeId;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformBodyStreamTerminatedMsg.java,v $
/* Revision 1.2  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
