//---------------------------------------------------------------------------
/* InformInvalStreamTerminatedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformInvalStreamTerminatedMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformInvalStreamTerminatedMsg(NodeId senderNodeId,
                                       SubscriptionSet ss){
    this.senderNodeId = senderNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informInvalStreamTerminated(senderNodeId, ss); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformInvalStreamTerminatedMsg: " + senderNodeId +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformInvalStreamTerminatedMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
