//---------------------------------------------------------------------------
/* InformLocalReadImpreciseMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformLocalReadImpreciseMsg extends ControllerInformMessage {
  
  private ObjId objId;
  private long offset;
  private long length;
 
//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformLocalReadImpreciseMsg(ObjId objId, long offset, long length){

    this.objId = objId;
    this.offset = offset;
    this.length =  length;
  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informLocalReadImprecise(objId, offset, length);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "informLocalReadImpreciseMsg: " + objId + ", " + offset + 
      ", " + length;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformLocalReadImpreciseMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
