//---------------------------------------------------------------------------
/* InformLocalReadInvalidMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformLocalReadInvalidMsg extends ControllerInformMessage {
  
  private ObjId objId;
  private long offset;
  private long length;
  private AcceptStamp as;
 
//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformLocalReadInvalidMsg(ObjId objId, long offset, long length,
                                   AcceptStamp as){

    this.objId = objId;
    this.offset = offset;
    this.length =  length;
    this.as = as;
  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informLocalReadInvalid(objId, offset, length, as);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "informLocalReadInvalidMsg: " + objId + ", " + offset + 
      ", " + length + ", " + as;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformLocalReadInvalidMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
