//---------------------------------------------------------------------------
/* InformLocalWriteMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformLocalWriteMsg extends ControllerInformMessage {
  
  private ObjId objId;
  private long offset;
  private long length;
  private AcceptStamp as;
  private boolean isBound;
  private boolean isEmbargoed;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformLocalWriteMsg(ObjId objId, long offset, long length,
                             AcceptStamp as, boolean isBound,
                             boolean isEmbargoed){
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.as = as;
    this.isBound = isBound;
    this.isEmbargoed = isEmbargoed;
  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informLocalWrite(objId, offset, length, as, isBound, isEmbargoed);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "informLocalWriteMsg: " + objId + ", " + offset + ", " + length +
      ", " + as + ", " + isBound + ", " + isEmbargoed; 
  }
}

//---------------------------------------------------------------------------
/* $Log: InformLocalWriteMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
