//---------------------------------------------------------------------------
/*  InformMsgWorkerThread
 *  
 * Takes a tuple from the controller inform queue and handles it
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.lang.*;

public class InformMsgWorkerThread extends Thread {
  private P2Runtime runtime;
  private BlockedQueue informQueue;

  private boolean dbg = false;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public InformMsgWorkerThread(P2Runtime runtime, Status status) {
    this.runtime = runtime;
    this.informQueue = status.getPendingControllerInformQueue();
  }

//---------------------------------------------------------------------------
// run - gets an item from the queue and inserts it into overlog
//---------------------------------------------------------------------------
 
  public void run(){
    while(true) {
      if(dbg){
	Env.dprintln(dbg, "InformWorkerThread: trying to get msg from queue");
      }
      ControllerInformMessage msg = (ControllerInformMessage) informQueue.getNext();
      if(dbg){
	Env.dprintln(dbg, "InformWorkerThread: got msg from queue: " + msg);
      }
      msg.handleMessage(runtime);
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: InformMsgWorkerThread.java,v $
/* Revision 1.2  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
