//---------------------------------------------------------------------------
/* InformOutgoingSubscribeBodyInitiatedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformOutgoingSubscribeBodyInitiatedMsg extends ControllerInformMessage {
  
  private NodeId receiverNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformOutgoingSubscribeBodyInitiatedMsg(NodeId receiverNodeId,
                                                  SubscriptionSet ss){
    this.receiverNodeId = receiverNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informOutgoingSubscribeBodyInitiated(receiverNodeId, ss);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformOutgoingSubscribeBodyInitiatedMsg: " + receiverNodeId  +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformOutgoingSubscribeBodyInitiatedMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
