//---------------------------------------------------------------------------
/* InformOutgoingSubscribeBodyTerminatedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformOutgoingSubscribeBodyTerminatedMsg extends ControllerInformMessage {
  
  private NodeId receiverNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformOutgoingSubscribeBodyTerminatedMsg(NodeId receiverNodeId,
                                                  SubscriptionSet ss){
    this.receiverNodeId = receiverNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informOutgoingSubscribeBodyTerminated(receiverNodeId, ss);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformOutgoingSubscribeBodyTerminatedMsg: " + receiverNodeId  +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformOutgoingSubscribeBodyTerminatedMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
