//---------------------------------------------------------------------------
/* InformOutgoingSubscribeInvalInitiatedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformOutgoingSubscribeInvalInitiatedMsg extends ControllerInformMessage {
  
  private NodeId receiverNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformOutgoingSubscribeInvalInitiatedMsg(NodeId receiverNodeId,
                                                  SubscriptionSet ss){
    this.receiverNodeId = receiverNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informOutgoingSubscribeInvalInitiated(receiverNodeId, ss);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformOutgoingSubscribeInvalInitiatedMsg: " + receiverNodeId  +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformOutgoingSubscribeInvalInitiatedMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
