//---------------------------------------------------------------------------
/* InformOutgoingSubscribeInvalTerminatedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformOutgoingSubscribeInvalTerminatedMsg extends ControllerInformMessage {
  
  private NodeId receiverNodeId;
  private SubscriptionSet ss;
  private boolean dbg=false;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformOutgoingSubscribeInvalTerminatedMsg(NodeId receiverNodeId,
                                                  SubscriptionSet ss){
    this.receiverNodeId = receiverNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    if(dbg){
      Env.dprintln(dbg, "InformOUtgoingSubscribeInvalTerminatedMsg: handle msg called");
    }
    runtime.informOutgoingSubscribeInvalTerminated(receiverNodeId, ss);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformOutgoingSubscribeInvalTerminatedMsg: " + receiverNodeId  +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformOutgoingSubscribeInvalTerminatedMsg.java,v $
/* Revision 1.3  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.2  2007/01/12 22:29:56  nalini
/* Fixed informRemovedSubscription bug
/*
/* Revision 1.1  2006/10/03 15:45:44  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
